// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics/Constraint/hkpConstraint.h>
#include <Physics/Constraint/Visualize/Drawer/hkpPointToPlaneDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpPrimitiveDrawer.h>
#include <Common/Base/Types/Color/hkColor.h>
#include <Common/Visualize/hkDebugDisplayHandler.h>

////////////////////////////////////////////////////////////////////

void hkpPointToPlaneDrawer::drawConstraint(_In_ const hkpPointToPlaneConstraintData* constraintData, const hkTransform& localToWorldA, const hkTransform& localToWorldB, _Inout_ hkDebugDisplayHandler* displayHandler, hkUint64 id, int tag)
{

    //const hkpPointToPlaneConstraintData* plane = static_cast<const hkpPointToPlaneConstraintData*>(constraint->getData());

    m_primitiveDrawer.setDisplayHandler(displayHandler);

    {
        const hkTransform& refLocalToWorld = localToWorldB;
        const hkTransform& attLocalToWorld = localToWorldA;
        updateCommonParameters(localToWorldA, localToWorldB);
        m_bodyBWPivot.setTransformedPos(refLocalToWorld, constraintData->m_atoms.m_transforms.m_transformB.getTranslation() );
        m_bodyAWPivot.setTransformedPos(attLocalToWorld, constraintData->m_atoms.m_transforms.m_transformA.getTranslation());
    }

    drawPivots(id, tag);

    drawBodyFrames(id, tag);

        // illustrate the constraint plane attached to body A
        // by drawing a set of lines in the plane
    {
        hkVector4 perpVec0; perpVec0.setRotatedDir(m_RB, constraintData->m_atoms.m_transforms.m_transformB.getColumn((constraintData->m_atoms.m_lin.m_axisIndex+1)%3) );
        hkVector4 perpVec1; perpVec1.setRotatedDir(m_RB, constraintData->m_atoms.m_transforms.m_transformB.getColumn((constraintData->m_atoms.m_lin.m_axisIndex+2)%3) );

        hkVector4 lines[6][2];
        for (int coord = 0; coord < 2; coord++)
        {
            for (int i = -1; i <= 1; i++)
            {
                hkVector4 v0 = coord ? perpVec0 : perpVec1;
                hkVector4 v1 = coord ? perpVec1 : perpVec0;
                lines[coord*3 + i + 1][0] = m_bodyBWPivot;
                lines[coord*3 + i + 1][1] = m_bodyBWPivot;
                lines[coord*3 + i + 1][0].addMul(hkSimdReal::fromFloat( 2.0f * getLineLengthForDraw()), v0);
                lines[coord*3 + i + 1][1].addMul(hkSimdReal::fromFloat(-2.0f * getLineLengthForDraw()), v0);
                lines[coord*3 + i + 1][0].addMul(hkSimdReal::fromFloat(hkReal(i) * 1.4f * getLineLengthForDraw()), v1);
                lines[coord*3 + i + 1][1].addMul(hkSimdReal::fromFloat(hkReal(i) * 1.4f * getLineLengthForDraw()), v1);
            }
        }

        for (int i = 0; i < 6; i++)
        {
            displayHandler->displayLine(id, lines[i][0],lines[i][1],hkColor::rgbFromFloats(0.8f,.8f,.8f), tag);
        }
    }

        // draw the pivot arm for body A
    displayHandler->displayLine(id, m_bodyAWPivot,m_bodyAWPos,hkColor::rgbFromFloats(0.3f,.3f,.8f), tag);
}

////////////////////////////////////////////////////////////////////

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
