// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics/Constraint/hkpConstraint.h>
#include <Physics/Constraint/Visualize/Drawer/hkpDeformableFixedConstraintDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpPrimitiveDrawer.h>

#include <Common/Visualize/hkDebugDisplayHandler.h>
#include <Common/Base/Types/Color/hkColor.h>


void hkpDeformableFixedConstraintDrawer::drawConstraint(_In_ const hkpDeformableFixedConstraintData* constraintData, const hkTransform& localToWorldA, const hkTransform& localToWorldB, _Inout_ hkDebugDisplayHandler* displayHandler, hkUint64 id, int tag)
{
    const hkpSetLocalTransformsConstraintAtom& pivots = constraintData->m_atoms.m_transforms;

    m_primitiveDrawer.setDisplayHandler(displayHandler);

    {
        const hkTransform& refLocalToWorld = localToWorldB;
        const hkTransform& attLocalToWorld = localToWorldA;
        updateCommonParameters(localToWorldA, localToWorldB);
        m_bodyBWPivot.setTransformedPos(refLocalToWorld, pivots.m_transformB.getTranslation());
        m_bodyAWPivot.setTransformedPos(attLocalToWorld, pivots.m_transformA.getTranslation());
    }

    drawPivots(id, tag);

    drawBodyFrames(id, tag);

    // Draw Error
    displayHandler->displayLine(id, m_bodyAWPivot, m_bodyBWPivot, hkColor::RED, tag);
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
