// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics/Constraint/hkpConstraint.h>
#include <Common/Visualize/Shape/hkDisplaySemiCircle.h>
#include <Physics/Constraint/Visualize/Drawer/hkp6DofConstraintDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpPrimitiveDrawer.h>
#include <Common/Base/Types/Color/hkColor.h>
#include <Common/Visualize/hkDebugDisplayHandler.h>
#include <Physics/Constraint/Data/6Dof/hkp6DofConstraintData.h>

void hkp6DofConstraintDrawer::drawConstraint(_In_ const hkp6DofConstraintData* constraintData, const hkTransform& localToWorldA, const hkTransform& localToWorldB, _Inout_ hkDebugDisplayHandler* displayHandler, hkUint64 id, int tag)
{
    for(int pass = 0; pass < 2; pass++)
    {
        hkpSetLocalTransformsConstraintAtom tempEllipticalTransforms;
        const hkpSetLocalTransformsConstraintAtom* transformAtom = &constraintData->m_blueprints.m_transforms;
        const hkpEllipticalLimitConstraintAtom* atom = &constraintData->m_blueprints.m_ellipticalLimit;

        if(pass == 1)
        {
            // Check if we have asymmetric swing limits;
                hkReal reorientAngle0 = constraintData->m_blueprints.m_ellipticalMinMax[0] * 0.5f + constraintData->m_blueprints.m_ellipticalMinMax[1] * 0.5f;
                hkReal reorientAngle1 = constraintData->m_blueprints.m_ellipticalMinMax[2] * 0.5f + constraintData->m_blueprints.m_ellipticalMinMax[3] * 0.5f;

                if(reorientAngle0 != 0.0f || reorientAngle1 != 0.0f)
                {
                    hkQuaternion adjust0;
                    adjust0.setAxisAngle( transformAtom->m_transformB.getColumn<1>(), reorientAngle0 );
                    hkRotation a0; a0.set(adjust0);

                    hkQuaternion adjust1;
                    adjust1.setAxisAngle( transformAtom->m_transformB.getColumn<2>(), reorientAngle1 );
                    hkRotation a1; a1.set(adjust1);

                    a1.mul(a0);
                    tempEllipticalTransforms.m_transformA = constraintData->m_blueprints.m_transforms.m_transformA;
                    tempEllipticalTransforms.m_transformB.setTranslation(constraintData->m_blueprints.m_transforms.m_transformB.getTranslation());
                    tempEllipticalTransforms.m_transformB.getRotation().setMul(a1, constraintData->m_blueprints.m_transforms.m_transformB.getRotation());
                    transformAtom = &tempEllipticalTransforms;
                }
        }

        const hkTransform& baseA = transformAtom->m_transformA;
        const hkTransform& baseB = transformAtom->m_transformB;

        m_primitiveDrawer.setDisplayHandler(displayHandler);

        {
            const hkTransform& refLocalToWorld = localToWorldB;
            const hkTransform& attLocalToWorld = localToWorldA;
            updateCommonParameters(localToWorldA, localToWorldB);
            m_bodyBWPivot.setTransformedPos(refLocalToWorld, baseB.getTranslation() );
            m_bodyAWPivot.setTransformedPos(attLocalToWorld, baseA.getTranslation() );
        }

        if(pass == 0)
        {
            drawPivots(id, tag);
        }

        hkTransform worldTconstraintA; worldTconstraintA.setMul( localToWorldA, baseA );
        hkTransform worldTconstraintB; worldTconstraintB.setMul( localToWorldB, baseB );


        // Get parameters from 6DofConstraint constraint
        const hkVector4& refTwistAxisWorld = worldTconstraintB.getColumn(0);
        const hkVector4& refSwing0Axis     = worldTconstraintB.getColumn(1);
        const hkVector4& refSwing1Axis     = worldTconstraintB.getColumn(2);

        const hkVector4& attTwistAxisWorld = worldTconstraintA.getColumn(0);
        const hkVector4& attSwing0World    = worldTconstraintA.getColumn(1);
        const hkVector4& attSwing1World    = worldTconstraintA.getColumn(2);

        /////////////////////////////////////////////
        hkReal size = getArrowSizeForDraw();
        hkSimdReal sizeSr = hkSimdReal::fromFloat(size);

        //always display twist axes
        if(pass == 0)
        {
            m_primitiveDrawer.displayArrow(m_bodyBWPivot, refTwistAxisWorld, refSwing0Axis, hkColor::GREEN,size, id, tag);
            m_primitiveDrawer.displayArrow(m_bodyAWPivot, attTwistAxisWorld, attSwing0World, hkColor::YELLOW, getArrowSizeForDraw(), id, tag);

            // draw the limits
            hkReal thetaMax = constraintData->getTwistMaxAngularLimit();
            hkReal thetaMin = constraintData->getTwistMinAngularLimit();
            if(thetaMax <= HK_REAL_PI && thetaMin >= -HK_REAL_PI)
            {

                hkDisplaySemiCircle limit;
                limit.setParameters(getArcRadiusForDraw(), thetaMin, thetaMax, getNumArcSegmentsForDraw(), m_bodyBWPivot, refTwistAxisWorld, refSwing0Axis);
                displayHandler->displayGeometry(id, &limit, hkTransform::getIdentity(), hkColor::WHITE, tag);
                m_primitiveDrawer.displayArrow(m_bodyAWPivot, attSwing0World, attTwistAxisWorld, hkColor::WHITE, getArcRadiusForDraw(), id, tag);
            }
        }


        // Draw linear limits for any constrained axes
        if(pass == 0)
        {
            hkVector4 allAxisMidpoint = hkVector4::getZero();
            for(int i = 0; i < 3; i++)
            {
                if(constraintData->getAxisMode((hkp6DofConstraintData::AxisIdentifier)(hkp6DofConstraintData::LINEAR_X + i)) != hkp6DofConstraintData::LIMITED)
                {
                    continue;
                }
                const hkpLinLimitConstraintAtom& linAtom = constraintData->m_blueprints.m_linearLimits[i];

                if(hkMath::fabs(linAtom.m_max) != HK_REAL_MAX && hkMath::fabs(linAtom.m_min) != HK_REAL_MAX)
                {
                    allAxisMidpoint.addMul(worldTconstraintB.getColumn(i), hkSimdReal::fromFloat(linAtom.m_min * 0.5f));
                    allAxisMidpoint.addMul(worldTconstraintB.getColumn(i), hkSimdReal::fromFloat(linAtom.m_max * 0.5f));
                }
            }

            for(int i = 0; i < 3; i++)
            {
                if(constraintData->getAxisMode((hkp6DofConstraintData::AxisIdentifier)(hkp6DofConstraintData::LINEAR_X + i)) != hkp6DofConstraintData::LIMITED)
                {
                    continue;
                }

                hkVector4 limitStop[2];
                limitStop[0].setAdd(allAxisMidpoint, m_bodyBWPivot);
                limitStop[0].subMul(worldTconstraintB.getColumn(i), worldTconstraintB.getColumn(i).dot3(allAxisMidpoint));
                limitStop[1] = limitStop[0];

                for(int v = 0; v < 2; v++)
                {
                    hkReal limitVal;
                    if(v == 0)
                    {
                        limitVal = constraintData->m_blueprints.m_linearLimits[i].m_min;
                    }
                    else
                    {
                        limitVal = constraintData->m_blueprints.m_linearLimits[i].m_max;
                    }

                    if(hkMath::fabs(limitVal) != HK_REAL_MAX)
                    {
                        limitStop[v].addMul(worldTconstraintB.getColumn(i), hkSimdReal::fromFloat(limitVal));
                        hkVector4 perpAxis = worldTconstraintB.getColumn((i + 1) % 3);
                
                        hkVector4 stopperLineMin;
                        stopperLineMin.setAddMul(limitStop[v], perpAxis, hkSimdReal::fromFloat(0.25f * getLineLengthForDraw()));
                        hkVector4 stopperLineMax;
                        stopperLineMax.setSubMul(limitStop[v], perpAxis, hkSimdReal::fromFloat(0.25f * getLineLengthForDraw()));
                        displayHandler->displayLine(id, stopperLineMin, stopperLineMax, hkColor::ORANGE, tag);
                    }
                }
                displayHandler->displayLine(id, limitStop[0], limitStop[1], hkColor::ORANGE, tag);
            }
        }

        // Draw stiff spring limit. This is the same as the hkpStiffSpringDrawer.
        if(constraintData->m_blueprints.m_stiffSpring.m_length != 0.0f && pass == 0)
        {
            hkVector4 dir;
            hkSimdReal dist;
            dir.setSub(m_bodyBWPivot,m_bodyAWPivot);
            dist = dir.length<3>();
            dir.normalize<3>();

            hkSimdReal springLength;
            springLength.setMin(dist, hkSimdReal::fromFloat(constraintData->m_blueprints.m_stiffSpring.m_maxLength));
            springLength.setMax(springLength, hkSimdReal::fromFloat(constraintData->m_blueprints.m_stiffSpring.m_length));

            hkVector4 minDir = dir;
            minDir.setMul(hkSimdReal::fromFloat(constraintData->m_blueprints.m_stiffSpring.m_length),dir);
            minDir.add(m_bodyAWPivot);

            dir.setMul(springLength,dir);
            dir.add(m_bodyAWPivot);

            displayHandler->displayLine(id, m_bodyAWPivot,minDir,hkColor::rgbFromFloats(0,.5f,1), tag);
            displayHandler->displayLine(id, minDir,dir,hkColor::rgbFromFloats(0,1.0f,0.4f), tag);
            displayHandler->displayLine(id, dir,m_bodyBWPivot,hkColor::RED, tag);
        }

        if(pass == 1)
        {   // draw the correction vector for the ellipse
            hkVector4 gradient;
            extern void hkp6DofConstraint_calculatePenaltyVectorForElipticalLimit( const hkpEllipticalLimitConstraintAtom* atom, const hkVector4& refTwistAxisWorld, const hkVector4& attTwistAxisWorld, const hkVector4& attSwing1World, const hkVector4& attSwing0World, const hkVector4& refSwing0Axis, const hkVector4& refSwing1Axis, hkVector4 &gradientOut );
            hkp6DofConstraint_calculatePenaltyVectorForElipticalLimit(atom, refTwistAxisWorld, attTwistAxisWorld, attSwing1World, attSwing0World, refSwing0Axis, refSwing1Axis, gradient);

            hkVector4 ta; ta.setAddMul( m_bodyAWPivot, attTwistAxisWorld, sizeSr);
            gradient.mul( sizeSr );
            m_primitiveDrawer.m_displayHandler->displayArrow(id, ta, gradient, hkColor::YELLOW, tag);
        }

        // draw a nice elliptical cone
        if(pass == 1)
        {
            hkVector4 lastPos  = m_bodyBWPivot;
            hkVector4 lastPos3 = m_bodyBWPivot;
            for (hkReal alpha = 0; alpha < HK_REAL_PI * 2.0f; alpha += 0.1f )
            {
                if(0)   // reference version using correct sin,cos for angles
                {
                    hkVector4 posOnSphere;
                    {
                        hkReal x = hkMath::sin(alpha);
                        hkReal y = hkMath::cos(alpha);
                        hkReal swing0 = atom->m_angle0;
                        hkReal swing1 = atom->m_angle1;
                        hkReal px = x * swing0;
                        hkReal py = y * swing1;
                        hkReal radius =  hkMath::sqrt(px*px + py*py);
                        px = px/radius; // project onto sphere, results in a direction
                        py = py/radius;
                        hkReal as = hkMath::sin(radius);
                        hkReal ac = hkMath::cos(radius);
                        hkReal nx = px * as;
                        hkReal ny = py * as;
                        hkReal nz = ac;
                        posOnSphere.set( nz, nx, ny );
                        posOnSphere.mul( sizeSr );
                    }

                    posOnSphere.setTransformedPos(worldTconstraintB, posOnSphere);
                    m_primitiveDrawer.m_displayHandler->displayLine( id, lastPos, posOnSphere, hkColor::YELLOW, tag );
                    m_primitiveDrawer.m_displayHandler->displayLine( id, m_bodyBWPivot, posOnSphere, hkColor::YELLOW, tag );
                    lastPos = posOnSphere;
                }
                if(1)
                {
                    hkBool isEllipse;
                    hkVector4 posOnSphere;  atom->getLimitProjectedOntoSphere(alpha, posOnSphere, isEllipse);
                    posOnSphere.mul( sizeSr );
                    posOnSphere.setTransformedPos(worldTconstraintB, posOnSphere);
                    m_primitiveDrawer.m_displayHandler->displayLine( id, lastPos3, posOnSphere, hkColor::GREEN, tag );
                    m_primitiveDrawer.m_displayHandler->displayLine( id, m_bodyBWPivot, posOnSphere, hkColor::GREEN, tag );
                    lastPos3 = posOnSphere;
                }

            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
