// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics/Constraint/Visualize/Drawer/hkpHingeDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpLimitedHingeDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpRagdollDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpPrismaticDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpWheelDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpStiffSpringDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpBallSocketDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpPointToPathDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpPointToPlaneDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpPulleyDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpHingeLimitsDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpRagdollLimitsDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpRackAndPinionDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpCogWheelDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpFixedConstraintDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkpDeformableFixedConstraintDrawer.h>
#include <Physics/Constraint/Visualize/Drawer/hkp6DofConstraintDrawer.h>

HK_INLINE void hkpDispatchDraw(_In_ const hkpConstraintData* constraintData, const hkTransform& localToWorldA, const hkTransform& localToWorldB, _Inout_ hkDebugDisplayHandler* displayHandler, hkUint64 id, int tag, hkReal scale )
{
    int type = constraintData->getType();

    switch(type)
    {
    case hkpConstraintData::CONSTRAINT_TYPE_BALLANDSOCKET:
        {
            hkpBallSocketDrawer drawer;
            drawer.setScale(scale);
            const hkpBallAndSocketConstraintData* data = static_cast<const hkpBallAndSocketConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_FIXED:
        {
            hkpFixedConstraintDrawer drawer;
            drawer.setScale(scale);
            const hkpFixedConstraintData* data = static_cast<const hkpFixedConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_DEFORMABLE_FIXED:
        {
            hkpDeformableFixedConstraintDrawer drawer;
            drawer.setScale(scale);
            const hkpDeformableFixedConstraintData* data = static_cast<const hkpDeformableFixedConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_HINGE:
        {
            hkpHingeDrawer drawer;
            drawer.setScale(scale);
            const hkpHingeConstraintData* data = static_cast<const hkpHingeConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_LIMITEDHINGE:
        {
            hkpLimitedHingeDrawer drawer;
            drawer.setScale(scale);
            const hkpLimitedHingeConstraintData* data = static_cast<const hkpLimitedHingeConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_PRISMATIC:
        {
            hkpPrismaticDrawer drawer;
            drawer.setScale(scale);
            const hkpPrismaticConstraintData* data = static_cast<const hkpPrismaticConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_STIFFSPRING:
        {
            hkpStiffSpringDrawer drawer;
            drawer.setScale(scale);
            const hkpStiffSpringConstraintData* data = static_cast<const hkpStiffSpringConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_WHEEL:
        {
            hkpWheelDrawer drawer;
            drawer.setScale(scale);
            const hkpWheelConstraintData* data = static_cast<const hkpWheelConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_POINTTOPATH:
        {
            hkpPointToPathDrawer drawer;
            drawer.setScale(scale);
            const hkpPointToPathConstraintData* data = static_cast<const hkpPointToPathConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_POINTTOPLANE:
        {
            hkpPointToPlaneDrawer drawer;
            drawer.setScale(scale);
            const hkpPointToPlaneConstraintData* data = static_cast<const hkpPointToPlaneConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_RAGDOLL:
        {
            hkpRagdollDrawer drawer;
            drawer.setScale(scale);
            const hkpRagdollConstraintData* data = static_cast<const hkpRagdollConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_6DOF:
        {
            hkp6DofConstraintDrawer drawer;
            drawer.setScale(scale);
            const hkp6DofConstraintData* data = reinterpret_cast<const hkp6DofConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_PULLEY:
        {
            hkpPulleyDrawer drawer;
            drawer.setScale(scale);
            const hkpPulleyConstraintData* data = static_cast<const hkpPulleyConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_RACK_AND_PINION:
        {
            hkpRackAndPinionDrawer drawer;
            drawer.setScale(scale);
            const hkpRackAndPinionConstraintData* data = static_cast<const hkpRackAndPinionConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;

    case hkpConstraintData::CONSTRAINT_TYPE_COG_WHEEL:
        {
            hkpCogWheelDrawer drawer;
            drawer.setScale(scale);
            const hkpCogWheelConstraintData* data = static_cast<const hkpCogWheelConstraintData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;
    case hkpConstraintData::CONSTRAINT_TYPE_HINGE_LIMITS:
        {
            hkpHingeLimitsDrawer drawer;
            drawer.setScale(scale);
            const hkpHingeLimitsData* data = static_cast<const hkpHingeLimitsData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;
    case hkpConstraintData::CONSTRAINT_TYPE_RAGDOLL_LIMITS:
        {
            hkpRagdollLimitsDrawer drawer;
            drawer.setScale(scale);
            const hkpRagdollLimitsData* data = static_cast<const hkpRagdollLimitsData*>(constraintData);
            drawer.drawConstraint(data, localToWorldA, localToWorldB, displayHandler, id, tag);
        }
        break;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
