// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/ConstraintSolver/Solve/hkpSolverResults.h>



/// Takes 1DOF state as input, and calculates the data, which goes into the constraint solver.
class HK_EXPORT_PHYSICS hkpConstraintMotor : public hkReferencedObject
{
    public:

        enum MotorType
        {
            TYPE_INVALID,
            TYPE_POSITION,
            TYPE_VELOCITY,
            TYPE_SPRING_DAMPER,
            TYPE_CALLBACK,
            TYPE_MAX
        };

    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT );
        HK_DECLARE_REFLECTION();

        /// Constructor
        inline hkpConstraintMotor() : m_type(TYPE_INVALID) {}

        /// Gets the type of the motor.
        inline MotorType getType() const { return m_type; }

        /// Clone the motor. As constraint data can be shared, but motors can't (normally, as they
        /// have per instance targets in them) we use a motor clone method to create new ones if required.
        virtual hkpConstraintMotor* clone() const = 0;

    public:

        hkEnum<MotorType, hkInt8> m_type;
};


//
class HK_EXPORT_PHYSICS hkpMaxSizeConstraintMotor : public hkpConstraintMotor
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT );

        hkpMaxSizeConstraintMotor() { m_type = TYPE_MAX; }

        virtual hkpConstraintMotor* clone() const  { HK_ASSERT(0xad67ddab, false, "Dummy implementation used."); return HK_NULL; }

    public:

#if defined(HK_REAL_IS_DOUBLE)
        hkUint32 m_dummy[1+2*8];
#else
        // Padding up to 32 bytes
#   if HK_POINTER_SIZE == 4
        hkUint32 m_dummy[1+2*4];
#   else // HK_POINTER_SIZE == 8
        hkUint32 m_dummy[1+2*8];
#   endif
#endif
};

HK_REFLECT_ENUM(HK_EXPORT_PHYSICS, hkpConstraintMotor::MotorType);

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
