// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Motor/LimitedForce/hkpLimitedForceConstraintMotor.h>


/// This motor simply tries to reach and keep a desired target velocity.
class HK_EXPORT_PHYSICS hkpVelocityConstraintMotor : public hkpLimitedForceConstraintMotor
{
    public:
        //+version(1)
        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT );
        HK_DECLARE_REFLECTION();

        /// Sets all values to reasonable defaults.
        hkpVelocityConstraintMotor();

        /// Construct a motor with the given properties.
        hkpVelocityConstraintMotor( hkReal velocityTarget, hkReal maxForce );

        /// Motor clone method.
        virtual hkpConstraintMotor* clone() const;

    public:

        /// The stiffness between 0 and 1.
        hkReal m_tau;

        /// The damping stiffness between 0 and 1.
        hkReal m_damping;

        /// Velocity target.
        hkReal m_velocityTarget;

        /// Tells the motor to ignore the stored velocity target.
        /// When set to true, the motor calculates the requested velocity from the target orientations
        /// supplied by the constraint owning the motor.
        hkBool m_useVelocityTargetFromConstraintTargets;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
