// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics/Constraint/hkpConstraint.h>
#include <Physics/Constraint/Motor/Velocity/hkpVelocityConstraintMotor.h>

hkpVelocityConstraintMotor::hkpVelocityConstraintMotor()
    : hkpLimitedForceConstraintMotor()
{
    m_type = TYPE_VELOCITY;
    setMaxForce( hkReal( 1e6f ) );
    m_velocityTarget = hkReal( 1 );
    m_tau = hkReal( 0.8f );
    m_damping = hkReal( 0.8f );
    m_useVelocityTargetFromConstraintTargets = false;
}

// Construct a motor with the given properties.
hkpVelocityConstraintMotor::hkpVelocityConstraintMotor( hkReal velocityTarget, hkReal maxForce )
    : hkpLimitedForceConstraintMotor(), m_velocityTarget( velocityTarget )
{
    m_type = TYPE_VELOCITY;
    setMaxForce( maxForce );
    m_tau = hkReal( 0.8f );
    m_damping = hkReal( 0.8f );
    m_useVelocityTargetFromConstraintTargets = false;
}

hkpConstraintMotor* hkpVelocityConstraintMotor::clone() const
{
    hkpVelocityConstraintMotor* vcm = new hkpVelocityConstraintMotor( *this );
    return vcm;
}

HK_COMPILE_TIME_ASSERT( sizeof(hkpVelocityConstraintMotor) <= sizeof(hkpMaxSizeConstraintMotor) );

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
