// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// this: #include <Physics/Constraint/Motor/Position/hkpPositionConstraintMotor.h>

#include <Physics/Constraint/Motor/LimitedForce/hkpLimitedForceConstraintMotor.h>


/// A motor which tries to reach a desired position/angle given a maxForce and a recovery speed.
/// Notes:
///  - this motor is a good choice for driving a ragdoll to a given pose.
///  - This motor accumulates the error over time to be able to achieve high forces.
///    This can lead to a small jitter, the first time the motor is activated.
///    To reduce this jitter, you can either try to fade in the motor's maxForce or
///    set the maxForce to some reasonable value.
class HK_EXPORT_PHYSICS hkpPositionConstraintMotor : public hkpLimitedForceConstraintMotor
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT );
        HK_DECLARE_REFLECTION();

        /// Sets some reasonable default values.
        hkpPositionConstraintMotor( hkReal currentPosition = 0.0f);

        /// Motor clone method.
        virtual hkpConstraintMotor* clone() const;

    public:

        /// The relative stiffness between 0 and 1.
        hkReal m_tau;

        /// The relative damping between 0 and 1.
        hkReal m_damping;

        /// A factor of the current error to calculate the recovery velocity.
        hkReal m_proportionalRecoveryVelocity;

        /// A constant velocity which is used to recover from errors.
        hkReal m_constantRecoveryVelocity;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
