// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Motor/LimitedForce/hkpLimitedForceConstraintMotor.h>

class hkpConstraintMotorInput;
class hkpConstraintMotorOutput;

/// This motor simply tries to reach and keep a desired target velocity.
class HK_EXPORT_PHYSICS hkpCallbackConstraintMotor : public hkpLimitedForceConstraintMotor
{
    public:

        typedef void (HK_CALL *CalcMotorDataCallbackFunc)(const class hkpCallbackConstraintMotor& motor, const hkpConstraintMotorInput* input, hkpConstraintMotorOutput* output);

        enum CallbackType
        {
            CALLBACK_MOTOR_TYPE_HAVOK_DEMO_SPRING_DAMPER,
            CALLBACK_MOTOR_TYPE_USER_0,
            CALLBACK_MOTOR_TYPE_USER_1,
            CALLBACK_MOTOR_TYPE_USER_2,
            CALLBACK_MOTOR_TYPE_USER_3,
        };

    public:

        HK_DECLARE_CLASS(hkpCallbackConstraintMotor, New, Reflect, BypassCtor);

        /// Construct a motor with the given properties.
        hkpCallbackConstraintMotor( enum CallbackType callbackType, CalcMotorDataCallbackFunc callbackFunc );

        /// Motor clone method
        virtual hkpConstraintMotor* clone() const;

    public:

        CalcMotorDataCallbackFunc m_callbackFunc; //+overridetype(void*) +nosave
        hkEnum<CallbackType,hkUint32> m_callbackType;
        hkUlong m_userData0; // +default(0)
        hkUlong m_userData1; // +default(0)
        hkUlong m_userData2; // +default(0)
};

HK_REFLECT_ENUM(HK_EXPORT_PHYSICS, hkpCallbackConstraintMotor::CallbackType);

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
