// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/hkpConstraint.h>
#include <Physics/Constraint/Data/hkpConstraintData.h>


/// This abstract class is the base class for wrappers that add properties to a constraint data (e.g. breakable, malleable).
/// This class only implements a few methods of constraint data, and the default behavior is to forward the calls to the
/// wrapped data.
class HK_EXPORT_PHYSICS hkpWrappedConstraintData : public hkpConstraintData
{
    public:

        HK_DECLARE_CLASS(hkpWrappedConstraintData, New, Reflect, BypassCtor);

        /// Creates a wrapped constraint data around the given constraint data
        hkpWrappedConstraintData( _In_ hkpConstraintData* constraintData );

        /// Accessor to the wrapped constraint data.
        virtual const hkpConstraintData* getWrappedConstraintData() const;

        /// Accessor to the wrapped constraint data.
        virtual hkpConstraintData* accessWrappedConstraintData();

        /// Deep clone the constraint.
        virtual hkpWrappedConstraintData* deepClone() const = 0;

        //
        // hkpConstraintData interface
        //

        /// Get the atoms structure of the wrapped constraint.
        virtual void getConstraintInfo( ConstraintInfo& infoOut ) const HK_OVERRIDE;

        /// Return whether the wrapped constraint is valid.
        virtual hkBool isValid() const HK_OVERRIDE;

        /// Get information about the size of the runtime data needed.
        /// This calls the underlying data's getRuntimeInfo() method.
        virtual void getRuntimeInfo( hkBool wantRuntime, RuntimeInfo& infoOut )const HK_OVERRIDE;

        /// Access to the solver results in a generic way. Use getRuntimeInfo() to get the number of solver results.
        /// This calls the underlying data's getSolverResults() method.
        virtual hkpSolverResults* getSolverResults( _In_ hkpConstraintRuntime* runtime ) const HK_OVERRIDE;

        /// Call this if this constraint data builds its atoms on the fly (like the hkp6DofConstraintData).
        virtual UpdateAtomsResult::Enum updateDirtyAtoms() HK_OVERRIDE;

        /// Returns the linear impulse applied by the solver
        virtual void getAppliedLinearImpulse(const hkTransform& worldFromBodyA, const hkTransform& worldFromBodyB,
            _In_ const struct hkpConstraintRuntime* runtime, _Out_ hkVector4& impulseOut) const HK_OVERRIDE;

    protected:

        /// Wrapped constraint data. Automatically reference counted.
        hkRefPtr<hkpConstraintData> m_constraintData;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
