// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


#include <Physics/Constraint/hkpConstraint.h>
#include <Physics/Constraint/Data/Wrapper/hkpWrappedConstraintData.h>

hkpWrappedConstraintData::hkpWrappedConstraintData( _In_ hkpConstraintData* wrappedConstraintData )
    : m_constraintData(wrappedConstraintData) {}

void hkpWrappedConstraintData::getConstraintInfo( ConstraintInfo& infoOut ) const
{
    m_constraintData->getConstraintInfo(infoOut);
}

hkBool hkpWrappedConstraintData::isValid() const
{
    return m_constraintData->isValid();
}

void hkpWrappedConstraintData::getRuntimeInfo( hkBool wantRuntime, RuntimeInfo& infoOut ) const
{
    m_constraintData->getRuntimeInfo(wantRuntime, infoOut);
}

hkpSolverResults* hkpWrappedConstraintData::getSolverResults( _In_ hkpConstraintRuntime* runtime ) const
{
    return m_constraintData->getSolverResults(runtime);
}

hkpConstraintData::UpdateAtomsResult::Enum hkpWrappedConstraintData::updateDirtyAtoms()
{
    return m_constraintData->updateDirtyAtoms();
}

const hkpConstraintData* hkpWrappedConstraintData::getWrappedConstraintData() const
{
     return m_constraintData;
}

hkpConstraintData* hkpWrappedConstraintData::accessWrappedConstraintData()
{
    return m_constraintData;
}

void hkpWrappedConstraintData::getAppliedLinearImpulse(const hkTransform& worldFromBodyA, const hkTransform& worldFromBodyB, _In_ const hkpConstraintRuntime* runtimeIn, _Out_ hkVector4& impulseOut) const
{
    return m_constraintData->getAppliedLinearImpulse(worldFromBodyA, worldFromBodyB, runtimeIn, impulseOut);
}

hkpWrappedConstraintData* hkpWrappedConstraintData::deepClone() const
{
    HK_ASSERT_NO_MSG(0x49be43d5, 0); 
    return HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
