// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics/Constraint/Data/hkpConstraintData.h>

class HK_EXPORT_PHYSICS hkpWheelFrictionConstraintData : public hkpConstraintData
{
    public:

        struct HK_EXPORT_PHYSICS Runtime
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpWheelFrictionConstraintData::Runtime );
            HK_DECLARE_REFLECTION();
            // No solver results, they're stored in the atom
        };

        struct HK_EXPORT_PHYSICS Atoms
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpWheelFrictionConstraintData::Atoms );
            HK_DECLARE_REFLECTION();

            Atoms() {}

            const hkpConstraintAtom* getAtoms() const
            {
                return &m_transforms;
            }

            int getSizeOfAllAtoms() const
            {
                return hkGetByteOffsetInt(getAtoms(), &m_friction+1);
            }

            hkpSetLocalTransformsConstraintAtom m_transforms;
            hkpWheelFrictionConstraintAtom      m_friction;
        };

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

        hkpWheelFrictionConstraintData() { m_atoms.m_friction.m_axle = HK_NULL; }

        void init( _In_ hkpWheelFrictionConstraintAtom::Axle* axle, hkReal radius );

        hkBool isValid() const HK_OVERRIDE;
        int getType() const HK_OVERRIDE;
        static inline Runtime* HK_CALL getRuntime( _In_opt_ hkpConstraintRuntime* runtime );
        void getRuntimeInfo( hkBool wantRuntime, hkpConstraintData::RuntimeInfo& infoOut ) const HK_OVERRIDE;
        void getConstraintInfo( hkpConstraintData::ConstraintInfo& infoOut ) const HK_OVERRIDE;

        void setInWorldSpace( const hkTransform& bodyATransform, const hkTransform& bodyBTransform, const hkVector4& contact, const hkVector4& forward, const hkVector4& side );
        void setMaxFrictionForce(hkReal maxFrictionForce);
        void setTorque(hkReal torque);
        void setInvInertia(hkReal invInertia);
        void setImpulseScaling(hkReal impulseScaling, hkReal impulseMax);

        // Get or set the spin velocity of the wheel from the wheel friction atom
        hkReal getSpinVelocity() const;
        void setSpinVelocity(hkReal spinVelocity);

        // Call after the physics step and before resetSolverData() to get the impulse applied by the solver
        hkReal getForwardFrictionImpulse() const;
        hkReal getSideFrictionImpulse() const;
        hkReal getForwardSlipImpulse() const;
        hkReal getSideSlipImpulse() const;

        // Reset solver outputs before each physics step
        void resetSolverData();

        /// Returns the linear impulse applied by the solver
        virtual void getAppliedLinearImpulse(const hkTransform& worldFromBodyA, const hkTransform& worldFromBodyB,
            _In_ const struct hkpConstraintRuntime* runtime, _Out_ hkVector4& impulseOut) const HK_OVERRIDE;

    public:

        Atoms m_atoms;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
