// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


inline void hkpStiffSpringConstraintData::setInWorldSpace(const hkTransform& bodyATransform,
                                                          const hkTransform& bodyBTransform,
                                                          const hkVector4& pivotAW,
                                                          const hkVector4& pivotBW)
{
    m_atoms.m_pivots.m_translationA.setTransformedInversePos(bodyATransform,pivotAW);
    m_atoms.m_pivots.m_translationB.setTransformedInversePos(bodyBTransform,pivotBW);

    hkVector4 sepDist;
    sepDist.setSub( pivotAW, pivotBW );
    sepDist.length<3>().store<1>( & m_atoms.m_spring.m_length );
    sepDist.length<3>().store<1>( &m_atoms.m_spring.m_maxLength );
}


inline void hkpStiffSpringConstraintData::setInBodySpace( const hkVector4& pivotA,const hkVector4& pivotB, hkReal restLength )
{
    setInBodySpace(pivotA, pivotB, restLength, restLength);
}

inline void hkpStiffSpringConstraintData::setInBodySpace( const hkVector4& pivotA,const hkVector4& pivotB, hkReal minLength, hkReal maxLength )
{
    m_atoms.m_pivots.m_translationA = pivotA;
    m_atoms.m_pivots.m_translationB = pivotB;
    m_atoms.m_spring.m_length = minLength;
    m_atoms.m_spring.m_maxLength = maxLength;
}

inline hkReal hkpStiffSpringConstraintData::getSpringMinLength() const
{
    return m_atoms.m_spring.m_length;
}

inline hkReal hkpStiffSpringConstraintData::getSpringMaxLength() const
{
    return m_atoms.m_spring.m_maxLength;
}


inline void hkpStiffSpringConstraintData::setSpringLength(hkReal minLength, hkReal maxLength)
{
    m_atoms.m_spring.m_length = minLength;
    m_atoms.m_spring.m_maxLength = maxLength;
}

inline void hkpStiffSpringConstraintData::setSpringLength(hkReal length)
{
    setSpringLength(length, length);
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
