// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics/Constraint/hkpConstraint.h>
#include <Physics/Constraint/Data/StiffSpring/hkpStiffSpringConstraintData.h>


hkpStiffSpringConstraintData::hkpStiffSpringConstraintData()
{
    m_atoms.m_pivots.m_translationA.setZero();
    m_atoms.m_pivots.m_translationB.setZero();
    m_atoms.m_setupStabilization.m_enabled = true;
    m_atoms.m_spring.m_length = hkReal(0);
    m_atoms.m_spring.m_maxLength = hkReal(0);
}

void hkpStiffSpringConstraintData::getConstraintInfo( hkpConstraintData::ConstraintInfo& infoOut ) const
{
    getConstraintInfoUtil( m_atoms.getAtoms(), m_atoms.getSizeOfAllAtoms(), infoOut );
}


void hkpStiffSpringConstraintData::getRuntimeInfo( hkBool wantRuntime, hkpConstraintData::RuntimeInfo& infoOut ) const
{
    if ( wantRuntime )
    {
        infoOut.m_numSolverResults = SOLVER_RESULT_MAX;
        infoOut.m_sizeOfExternalRuntime = sizeof( Runtime );
    }
    else
    {
        infoOut.m_numSolverResults = 0;
        infoOut.m_sizeOfExternalRuntime = 0;
    }
}


hkBool hkpStiffSpringConstraintData::isValid() const
{
    return m_atoms.m_spring.m_length > hkReal(0) && m_atoms.m_spring.m_maxLength >= m_atoms.m_spring.m_length;
}


int hkpStiffSpringConstraintData::getType() const
{
    return hkpConstraintData::CONSTRAINT_TYPE_STIFFSPRING;
}

void hkpStiffSpringConstraintData::getAppliedLinearImpulse(const hkTransform& worldFromBodyA, const hkTransform& worldFromBodyB, _In_ const struct hkpConstraintRuntime* runtimeIn, _Out_ hkVector4& impulseOut) const
{
    const Runtime* rt   = reinterpret_cast<const Runtime*>(runtimeIn);
    hkVector4 ptA;      ptA.setTransformedPos(worldFromBodyA, m_atoms.m_pivots.m_translationA);
    hkVector4 ptB;      ptB.setTransformedPos(worldFromBodyB, m_atoms.m_pivots.m_translationB);
    hkVector4 dirAB;    dirAB.setSub(ptB, ptA);
                        dirAB.normalizeIfNotZero<3>();

    impulseOut.setMul(hkSimdReal::fromFloat(rt->m_solverResults[0].m_impulseApplied), dirAB);
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
