// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics/Constraint/hkpConstraint.h>
#include <Physics/Constraint/Data/Rotational/hkpRotationalConstraintData.h>


hkpRotationalConstraintData::hkpRotationalConstraintData()
{
    m_atoms.m_rotations.m_rotationA.setIdentity();
    m_atoms.m_rotations.m_rotationB.setIdentity();

    m_atoms.m_ang.m_constrainedAxes[0] = 0;
    m_atoms.m_ang.m_constrainedAxes[1] = 1;
    m_atoms.m_ang.m_constrainedAxes[2] = 2;
    m_atoms.m_ang.m_numConstrainedAxes = 3;
}

void hkpRotationalConstraintData::setInWorldSpace(const hkQuaternion& bodyARotation, const hkQuaternion& bodyBRotation)
{
    m_atoms.m_rotations.m_rotationA.set(bodyARotation);
    m_atoms.m_rotations.m_rotationB.set(bodyBRotation);
}

void hkpRotationalConstraintData::setInBodySpace(const hkQuaternion& aTb)
{
    m_atoms.m_rotations.m_rotationA.setIdentity();
    m_atoms.m_rotations.m_rotationB.set(aTb);
}

void hkpRotationalConstraintData::getConstraintInfo( hkpConstraintData::ConstraintInfo& infoOut ) const
{
    getConstraintInfoUtil( m_atoms.getAtoms(), m_atoms.getSizeOfAllAtoms(), infoOut );
}

void hkpRotationalConstraintData::getRuntimeInfo( hkBool wantRuntime, hkpConstraintData::RuntimeInfo& infoOut ) const
{
    if ( wantRuntime )
    {
        infoOut.m_numSolverResults = SOLVER_RESULT_MAX;
        infoOut.m_sizeOfExternalRuntime = sizeof( Runtime );
    }
    else
    {
        infoOut.m_numSolverResults = 0;
        infoOut.m_sizeOfExternalRuntime = 0;
    }
}

hkBool hkpRotationalConstraintData::isValid() const
{
    return m_atoms.m_rotations.m_rotationA.isOrthonormal() && m_atoms.m_rotations.m_rotationB.isOrthonormal();
}

int hkpRotationalConstraintData::getType() const
{
    return hkpConstraintData::CONSTRAINT_TYPE_ROTATIONAL;
}

//
//  Returns the linear impulse applied by the solver

void hkpRotationalConstraintData::getAppliedLinearImpulse(const hkTransform& worldFromBodyA, const hkTransform& worldFromBodyB, _In_ const hkpConstraintRuntime* runtime, _Out_ hkVector4& impulseOut) const
{
    // Does not apply a linear impulse
    impulseOut.setZero();
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
