// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


inline void hkpRagdollConstraintData::setTwistMinAngularLimit(hkReal rad)
{
    m_atoms.m_twistLimit.m_minAngle = rad;
}

inline void hkpRagdollConstraintData::setTwistMaxAngularLimit(hkReal rad)
{
    m_atoms.m_twistLimit.m_maxAngle = rad;
}

inline void hkpRagdollConstraintData::setPlaneMinAngularLimit(hkReal rad)
{
    m_atoms.m_planesLimit.m_minAngle = rad;
}

inline void hkpRagdollConstraintData::setPlaneMaxAngularLimit(hkReal rad)
{
    m_atoms.m_planesLimit.m_maxAngle = rad;
}
inline void hkpRagdollConstraintData::setConeAngularLimit(hkReal rad)
{
    m_atoms.m_coneLimit.m_maxAngle = rad;
}

inline hkReal hkpRagdollConstraintData::getTwistMinAngularLimit() const
{
    return m_atoms.m_twistLimit.m_minAngle;
}

inline hkReal hkpRagdollConstraintData::getTwistMaxAngularLimit() const
{
    return m_atoms.m_twistLimit.m_maxAngle;
}

inline hkReal hkpRagdollConstraintData::getPlaneMinAngularLimit() const
{
    return m_atoms.m_planesLimit.m_minAngle;
}

inline hkReal hkpRagdollConstraintData::getPlaneMaxAngularLimit() const
{
    return m_atoms.m_planesLimit.m_maxAngle;
}

inline hkReal hkpRagdollConstraintData::getConeAngularLimit() const
{
    return m_atoms.m_coneLimit.m_maxAngle;
}

inline hkBool hkpRagdollConstraintData::getConeLimitStabilization() const
{
    return 0 != m_atoms.m_coneLimit.m_memOffsetToAngleOffset;
}

inline hkReal hkpRagdollConstraintData::getMaxFrictionTorque() const
{
    return m_atoms.m_angFriction.m_maxFrictionTorque;
}

inline void hkpRagdollConstraintData::setAngularLimitsTauFactor( hkReal mag )
{
    m_atoms.m_twistLimit.m_angularLimitsTauFactor  = mag;
    m_atoms.m_coneLimit.m_angularLimitsTauFactor   = mag;
    m_atoms.m_planesLimit.m_angularLimitsTauFactor = mag;
}

inline hkReal hkpRagdollConstraintData::getAngularLimitsTauFactor() const
{
    if (m_atoms.m_twistLimit.m_angularLimitsTauFactor != m_atoms.m_coneLimit.m_angularLimitsTauFactor
     || m_atoms.m_twistLimit.m_angularLimitsTauFactor != m_atoms.m_planesLimit.m_angularLimitsTauFactor)
    {
        HK_WARN(0xad6ddbbd, "TauFactor for varies for individual limits of a hkpRagdollConstraintData");
    }

    return m_atoms.m_twistLimit.m_angularLimitsTauFactor;
}

inline hkBool hkpRagdollConstraintData::areMotorsEnabled() const
{
    return m_atoms.m_ragdollMotors.m_isEnabled;
}

inline void hkpRagdollConstraintData::afterReflectNew()
{
    if( getConeLimitStabilization())
    {
        // Ensure the offset is correct
        setConeLimitStabilization(true);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
