// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Data/hkpConstraintData.h>


//
class HK_EXPORT_PHYSICS hkpPulleyConstraintData : public hkpConstraintData
{
    public:

        enum
        {
            SOLVER_RESULT_LIN_0 = 0,    // linear constraint
            SOLVER_RESULT_MAX   = 1
        };

        struct Runtime
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpPulleyConstraintData::Runtime );

            hkpSolverResults m_solverResults[SOLVER_RESULT_MAX];
        };

        struct Atoms
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpPulleyConstraintData::Atoms );
            HK_DECLARE_REFLECTION();

            Atoms() {}

            // get a pointer to the first atom
            const hkpConstraintAtom* getAtoms() const { return &m_translations; }

            // get the size of all atoms (we can't use sizeof(*this) because of align16 padding)
            int getSizeOfAllAtoms() const { return hkGetByteOffsetInt(this, &m_pulley+1); }

            hkpSetLocalTranslationsConstraintAtom    m_translations;
            hkpPulleyConstraintAtom                  m_pulley;
        };

    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

        /// Constructor.
        hkpPulleyConstraintData();

        /// Sets the pulley up with world space information.
        /// Will compute a rest length too (so call setlength after this if needed)
        inline void setInWorldSpace(const hkTransform& bodyATransform, const hkTransform& bodyBTransform,
                                const hkVector4& pivotAW, const hkVector4& pivotBW,
                                const hkVector4& pulleyPivotAW, const hkVector4& pulleyPivotBW, hkReal leverageOnBodyB );

        /// Sets the pulley up with body space information.
        /// Will compute a rest length too (so call setlength after this if needed)
        /// and that is why the transforms are given (so that the length can be computed in world space)
        inline void setInBodySpace(const hkTransform& bodyATransform, const hkTransform& bodyBTransform,
                                const hkVector4& pivotA, const hkVector4& pivotB,
                                const hkVector4& pulleyPivotAW, const hkVector4& pulleyPivotBW, hkReal leverageOnBodyB );

        /// Gets the length of the rope. Full length == length of rope from bodyA to pulleyPivotA + leverageRation * (length of rope from body B to pulleyPivotB)
        inline hkReal getRopeLength() const;

        /// Gets the leverage ratio of the pulley. Pulley exerts 'leverageRatio' times greater forces on bodyB.
        inline hkReal getLeverageOnBodyB() const;

        /// Sets the length of the rope. Full length == length of rope from bodyA to pulleyPivotA + leverageRation * (length of rope from body B to pulleyPivotB)
        inline void setRopeLength(hkReal length);

        /// Sets the leverage ratio of the pulley. Pulley exerts 'leverageRatio' times greater forces on bodyB.
        inline void setLeverageOnBodyB(hkReal leverageOnBodyB);

        inline const Runtime* getRuntime( _In_opt_ hkpConstraintRuntime* runtime ) const { return reinterpret_cast<Runtime*>(runtime); }

        //
        // hkpConstraintData implementation
        //

        virtual int getType() const;

        hkBool isValid() const;

        virtual void getConstraintInfo( hkpConstraintData::ConstraintInfo& infoOut ) const;

        virtual void getRuntimeInfo( hkBool wantRuntime, hkpConstraintData::RuntimeInfo& infoOut ) const;

    public:

        Atoms m_atoms;
};

#include <Physics/Constraint/Data/Pulley/hkpPulleyConstraintData.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
