// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline void hkpPointToPlaneConstraintData::setInWorldSpace(const hkTransform& bodyATransform,
                                                     const hkTransform& bodyBTransform,
                                                     const hkVector4& pivotW,
                                                     const hkVector4& planeNormalW)
{
    m_pivotInA.setTransformedInversePos(bodyATransform,pivotW);
    m_pivotInB.setTransformedInversePos(bodyBTransform,pivotW);
    m_planeNormalA.setRotatedInverseDir(bodyATransform.getRotation(), planeNormalW);
}

inline void hkpPointToPlaneConstraintData::setInBodySpace( const hkVector4& pivotA,const hkVector4& pivotB, const hkVector4& planeNormalA )
{
    m_pivotInA = pivotA;
    m_pivotInB = pivotB;
    m_planeNormalA = planeNormalA;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
