// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Data/hkpConstraintData.h>


/// This constrains a point of one body to lie on a plane relative to the second body.
class HK_EXPORT_PHYSICS hkpPointToPlaneConstraintData : public hkpConstraintData
{
    public:

        enum
        {
            SOLVER_RESULT_LIN_0 = 0,    // linear constraint
            SOLVER_RESULT_MAX   = 1
        };

        struct Runtime
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpPointToPlaneConstraintData::Runtime );

            hkpSolverResults m_solverResults[SOLVER_RESULT_MAX];
        };

        struct Atoms
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpPointToPlaneConstraintData::Atoms );
            HK_DECLARE_REFLECTION();

            Atoms() {}

            // get a pointer to the first atom
            const hkpConstraintAtom* getAtoms() const { return &m_transforms; }

            // get the size of all atoms (we can't use sizeof(*this) because of align16 padding)
            int getSizeOfAllAtoms() const { return hkGetByteOffsetInt(this, &m_lin+1); }

            hkpSetLocalTransformsConstraintAtom m_transforms;
            hkpLinConstraintAtom                m_lin;
        };

    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

        /// Constructor.
        hkpPointToPlaneConstraintData();

        /// Sets the point-to-plane up with world space information.
        /// \param pivotW Specifies both the origin point for the constraining plane, and bodyB's pivot point, specified in world space.
        /// \param planeNormalW Specifies the normal direction of the constraining plane, specified in world space.
        void setInWorldSpace(const hkTransform& bodyATransform, const hkTransform& bodyBTransform,
                                const hkVector4& pivotW, const hkVector4& planeNormalW);

        /// Sets the point-to-plane up with body space information.
        /// \param pivotA Specifies the origin point for the constraining plane, specified in bodyA's space.
        /// \param pivotB BodyB's pivot point, specified in bodyB's space.
        /// \param planeNormalB Specifies the normal direction of the constraining plane, specified in bodyB's space.
        void setInBodySpace(const hkVector4& pivotA, const hkVector4& pivotB, const hkVector4& planeNormalB);

        inline const Runtime* getRuntime( _In_opt_ hkpConstraintRuntime* runtime ) const { return reinterpret_cast<Runtime*>(runtime); }

        //
        // hkpConstraintData implementation
        //

        virtual int getType() const HK_OVERRIDE;

        virtual hkBool isValid() const HK_OVERRIDE;

        virtual void getConstraintInfo( ConstraintInfo& infoOut ) const HK_OVERRIDE;

        virtual void getRuntimeInfo( hkBool wantRuntime, hkpConstraintData::RuntimeInfo& infoOut ) const HK_OVERRIDE;

        /// Returns the linear impulse applied by the solver
        virtual void getAppliedLinearImpulse(const hkTransform& worldFromBodyA, const hkTransform& worldFromBodyB,
            _In_ const struct hkpConstraintRuntime* runtime, _Out_ hkVector4& impulseOut) const HK_OVERRIDE;

    public:

        Atoms m_atoms;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
