// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE void hkpDeformableFixedConstraintData::setLinearLimit(hkReal maxDistance)
{
    m_atoms.m_lin.setMaxDistance(hkSimdReal::fromFloat(maxDistance));
}

HK_INLINE void hkpDeformableFixedConstraintData::setLinearOffset(hkVector4Parameter vOffset)
{
    m_atoms.m_lin.setOffset(vOffset);
}

HK_INLINE void hkpDeformableFixedConstraintData::setLinearStrength(const hkSymmetricMatrix3& linearYieldStrength, const hkSymmetricMatrix3& linearUltimateStrength)
{
    m_atoms.m_lin.setYieldStrength(linearYieldStrength);
    m_atoms.m_lin.setUltimateStrength(linearUltimateStrength);
}

HK_INLINE void hkpDeformableFixedConstraintData::setAngularLimit(hkReal maxAngle)
{
    const hkReal cosAMax = hkMath::cos(maxAngle);
    m_atoms.m_ang.setCosMaxAngle(hkSimdReal::fromFloat(cosAMax));
}

HK_INLINE void hkpDeformableFixedConstraintData::setAngularOffset(hkQuaternionParameter qOffset)
{
    m_atoms.m_ang.setOffset(qOffset);
}

HK_INLINE void hkpDeformableFixedConstraintData::setAngularStrength(const hkSymmetricMatrix3& angularYieldStrength, const hkSymmetricMatrix3& angularUltimateStrength)
{
    m_atoms.m_ang.setYieldStrength(angularYieldStrength);
    m_atoms.m_ang.setUltimateStrength(angularUltimateStrength);
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
