// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Data/hkpConstraintData.h>


/// A fixed constraint that allows deformation.
class HK_EXPORT_PHYSICS hkpDeformableFixedConstraintData : public hkpConstraintData
{
    public:

        enum
        {
            SOLVER_RESULT_LIN_0 = 0,    // Linear constraint 0
            SOLVER_RESULT_LIN_1 = 1,    // Linear constraint 1
            SOLVER_RESULT_LIN_2 = 2,    // Linear constraint 2
            SOLVER_RESULT_ANG_0 = 3,    // Angular constraint 0
            SOLVER_RESULT_ANG_1 = 4,    // Angular constraint 1
            SOLVER_RESULT_ANG_2 = 5,    // Angular constraint 2
            SOLVER_RESULT_MAX   = 6
        };

        struct Runtime
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DYNAMICS, hkpDeformableFixedConstraintData::Runtime);

            HK_ALIGN16( hkpSolverResults m_solverResults[SOLVER_RESULT_MAX] );
        };

        struct Atoms
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DYNAMICS, hkpDeformableFixedConstraintData::Atoms);
            HK_DECLARE_REFLECTION();

            Atoms() {}

            // Get a pointer to the first atom
            const hkpConstraintAtom* getAtoms() const { return &m_transforms; }

            int getSizeOfAllAtoms() const { return hkGetByteOffsetInt(this, &m_ang+1); }

            hkpSetLocalTransformsConstraintAtom m_transforms;
            hkpDeformableLinConstraintAtom      m_lin;
            hkpDeformableAngConstraintAtom      m_ang;
        };

    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

        /// Constructor
        hkpDeformableFixedConstraintData();

        /// Sets the construction information with body space information.
        /// \param pivotA The constraint pivot, specified in bodyA's space.
        /// \param pivotB The constraint pivot, specified in bodyB's space.
        void setInBodySpace(const hkTransform& pivotA, const hkTransform& pivotB);

        /// Sets the construction information with world space information. Will use the
        /// given transforms to work out the two local pivots.
        /// \param bodyA The first rigid body transform
        /// \param bodyB The second rigid body transform
        /// \param pivot The constraint pivot, specified in world space.
        void setInWorldSpace(const hkTransform& bodyATransform, const hkTransform& bodyBTransform, const hkTransform& pivotA, const hkTransform& pivotB);

        /// Sets the maximum distance
        HK_INLINE void setLinearLimit(hkReal maxDistance);

        /// Sets the linear offset
        HK_INLINE void setLinearOffset(hkVector4Parameter vOffset);

        /// Sets the linear strength tensors
        HK_INLINE void setLinearStrength(const hkSymmetricMatrix3& linearYieldStrength, const hkSymmetricMatrix3& linearUltimateStrength);

        /// Sets the maximum allowed angle
        HK_INLINE void setAngularLimit(hkReal maxAngle);

        /// Sets the angular offset
        HK_INLINE void setAngularOffset(hkQuaternionParameter qOffset);

        /// Sets the angular strength tensors
        HK_INLINE void setAngularStrength(const hkSymmetricMatrix3& angularYieldStrength, const hkSymmetricMatrix3& angularUltimateStrength);

        static inline Runtime* HK_CALL getRuntime( _In_opt_ hkpConstraintRuntime* runtime ) { return reinterpret_cast<Runtime*>(runtime); }

        //
        // hkpConstraintData implementation
        //

        virtual int getType() const HK_OVERRIDE;

        virtual hkBool isValid() const HK_OVERRIDE;

        virtual void getConstraintInfo( hkpConstraintData::ConstraintInfo& infoOut ) const HK_OVERRIDE;

        virtual void getRuntimeInfo( hkBool wantRuntime, hkpConstraintData::RuntimeInfo& infoOut ) const HK_OVERRIDE;

        /// Returns the linear impulse applied by the solver
        virtual void getAppliedLinearImpulse(const hkTransform& worldFromBodyA, const hkTransform& worldFromBodyB,
            _In_ const struct hkpConstraintRuntime* runtime, _Out_ hkVector4& impulseOut) const HK_OVERRIDE;

    public:

        Atoms m_atoms;
};

#include <Physics/Constraint/Data/DeformableFixed/hkpDeformableFixedConstraintData.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
