// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics/Constraint/hkpConstraint.h>
#include <Physics/Constraint/Data/DeformableFixed/hkpDeformableFixedConstraintData.h>


hkpDeformableFixedConstraintData::hkpDeformableFixedConstraintData()
{
    m_atoms.m_transforms.m_transformA.setIdentity();
    m_atoms.m_transforms.m_transformB.setIdentity();

    // Set an infinite strength
    hkSymmetricMatrix3 t;
    t.setDiagonal(hkSimdReal::getConstant<HK_QUADREAL_MAX>());

    setLinearStrength(t, t);
    setAngularStrength(t, t);
}

void hkpDeformableFixedConstraintData::setInWorldSpace(const hkTransform& bodyATransform, const hkTransform& bodyBTransform, const hkTransform& pivotA, const hkTransform& pivotB)
{
    m_atoms.m_transforms.m_transformA._setMulInverseMul(bodyATransform, pivotA);
    m_atoms.m_transforms.m_transformB._setMulInverseMul(bodyBTransform, pivotB);

    // Compute initial offsets
    hkVector4 vLinOffset;
    vLinOffset.setSub(pivotB.getTranslation(), pivotA.getTranslation());
    vLinOffset._setRotatedInverseDir(bodyATransform.getRotation(), vLinOffset);

    hkRotation relRotAB;        relRotAB.setMulInverseMul(pivotA.getRotation(), pivotB.getRotation());
    hkQuaternion qAngOffset;    qAngOffset.setAndNormalize(relRotAB);

    // Set-up the Destruction constraint atom
    m_atoms.m_lin.setOffset(vLinOffset);
    m_atoms.m_ang.setOffset(qAngOffset);
}

void hkpDeformableFixedConstraintData::setInBodySpace(const hkTransform& pivotA, const hkTransform& pivotB)
{
    m_atoms.m_transforms.m_transformA = pivotA;
    m_atoms.m_transforms.m_transformB = pivotB;
}

void hkpDeformableFixedConstraintData::getConstraintInfo(hkpConstraintData::ConstraintInfo& infoOut) const
{
    getConstraintInfoUtil(m_atoms.getAtoms(), m_atoms.getSizeOfAllAtoms(), infoOut);
}

void hkpDeformableFixedConstraintData::getRuntimeInfo(hkBool wantRuntime, hkpConstraintData::RuntimeInfo& infoOut) const
{
    if ( wantRuntime )
    {
        infoOut.m_numSolverResults      = SOLVER_RESULT_MAX;
        infoOut.m_sizeOfExternalRuntime = sizeof(Runtime);
    }
    else
    {
        infoOut.m_numSolverResults      = 0;
        infoOut.m_sizeOfExternalRuntime = 0;
    }
}

hkBool hkpDeformableFixedConstraintData::isValid() const
{
    return true;
}

int hkpDeformableFixedConstraintData::getType() const
{
    return hkpConstraintData::CONSTRAINT_TYPE_DEFORMABLE_FIXED;
}

//
//  Returns the linear impulse applied by the solver

void hkpDeformableFixedConstraintData::getAppliedLinearImpulse( const hkTransform& worldFromBodyA, const hkTransform& worldFromBodyB, _In_ const hkpConstraintRuntime* runtimeIn, _Out_ hkVector4& impulseOut ) const
{
    const Runtime* rt   = reinterpret_cast<const Runtime*>(runtimeIn);
    const hkReal px     = rt->m_solverResults[SOLVER_RESULT_LIN_0].m_impulseApplied;
    const hkReal py     = rt->m_solverResults[SOLVER_RESULT_LIN_1].m_impulseApplied;
    const hkReal pz     = rt->m_solverResults[SOLVER_RESULT_LIN_2].m_impulseApplied;

    impulseOut.set(px, py, pz);
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
