// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


inline void hkpLinearClearanceConstraintData::setLimits(hkReal min0, hkReal max0, hkReal min1, hkReal max1, hkReal min2, hkReal max2)
{
    m_atoms.m_linLimit0.m_min = min0;
    m_atoms.m_linLimit0.m_max = max0;
    m_atoms.m_linLimit1.m_min = min1;
    m_atoms.m_linLimit1.m_max = max1;
    m_atoms.m_linLimit2.m_min = min2;
    m_atoms.m_linLimit2.m_max = max2;
}

inline void hkpLinearClearanceConstraintData::setMaxFrictionForce(hkReal fmag)
{
    m_atoms.m_friction0.m_maxFrictionForce = fmag;
    m_atoms.m_friction1.m_maxFrictionForce = fmag;
    m_atoms.m_friction2.m_maxFrictionForce = fmag;
}


inline hkReal hkpLinearClearanceConstraintData::getMaxFrictionForce() const
{
    return m_atoms.m_friction0.m_maxFrictionForce;
}

inline hkpConstraintMotor* hkpLinearClearanceConstraintData::getMotor() const
{
    return m_atoms.m_motor.m_motor;
}

inline hkBool hkpLinearClearanceConstraintData::isMotorEnabled() const
{
    return m_atoms.m_motor.m_isEnabled;
}

inline void hkpLinearClearanceConstraintData::setMotorTargetPosition( hkReal pos )
{
    m_atoms.m_motor.m_targetPosition = pos;
}

inline hkReal hkpLinearClearanceConstraintData::getMotorTargetPosition() const
{
    return m_atoms.m_motor.m_targetPosition;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
