// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Data/hkpConstraintData.h>


/// The ball-and-socket or point-to-point constraint.
class HK_EXPORT_PHYSICS hkpBallAndSocketConstraintData : public hkpConstraintData
{
    public:

        enum
        {
            SOLVER_RESULT_LIN_0 = 0,        // linear constraint
            SOLVER_RESULT_LIN_1 = 1,        // linear constraint
            SOLVER_RESULT_LIN_2 = 2,        // linear constraint
            SOLVER_RESULT_MAX = 3
        };

        struct Runtime
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpBallAndSocketConstraintData::Runtime );

            hkpSolverResults m_solverResults[SOLVER_RESULT_MAX];
        };

        struct Atoms
        {
            // +version(1)
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpBallAndSocketConstraintData::Atoms );
            HK_DECLARE_REFLECTION();

            Atoms() {}

            // get a pointer to the first atom
            const hkpConstraintAtom* getAtoms() const { return &m_pivots; }

            int getSizeOfAllAtoms() const { return hkGetByteOffsetInt(this, &m_ballSocket+1); }

            hkpSetLocalTranslationsConstraintAtom   m_pivots;
            hkpSetupStabilizationAtom               m_setupStabilization;
            hkpBallSocketConstraintAtom             m_ballSocket;
        };

    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

        /// Constructor.
        hkpBallAndSocketConstraintData();

        /// Sets the construction information with body space information.
        /// \param pivotA The constraint pivot point, specified in bodyA's space.
        /// \param pivotB The constraint pivot point, specified in bodyB's space.
        void setInBodySpace(const hkVector4& pivotA, const hkVector4& pivotB);

        /// Sets the construction information with world space information. Will use the
        /// given transforms to work out the two local pivots.
        /// \param bodyA The first rigid body transform
        /// \param bodyB The second rigid body transform
        /// \param pivot The constraint pivot point, specified in world space.
        void setInWorldSpace(const hkTransform& bodyATransform, const hkTransform& bodyBTransform,
                            const hkVector4& pivot);

        inline const Runtime* getRuntime( _In_opt_ hkpConstraintRuntime* runtime ) const { return reinterpret_cast<Runtime*>(runtime); }

        //
        // hkpConstraintData implementation
        //

        /// Get type from this constraint.
        virtual int getType() const HK_OVERRIDE;

        /// Check consistency of constraint members.
        virtual hkBool isValid() const HK_OVERRIDE;

        /// Get the atoms structure of this constraint.
        virtual void getConstraintInfo( hkpConstraintData::ConstraintInfo& infoOut ) const HK_OVERRIDE;

        /// Sets the impulse above which this constraint is reported as breached.
        /// Set it to HK_REAL_MAX to disable breach reporting.
        virtual void setBreachImpulse(hkReal breachImpulse) HK_OVERRIDE;

        /// Gets the impulse above which this constraint is reported as breached.
        virtual hkReal getBreachImpulse() const HK_OVERRIDE;

        /// Sets the maximum linear impulse the solver is allowed to apply to maintain this constraint.
        /// Call with HK_REAL_MAX to effectively disable the limit.
        virtual void setMaximumLinearImpulse(hkReal maxLinearImpulse) HK_OVERRIDE;

        /// Gets the maximum impulse that can be applied by this constraint.
        virtual hkReal getMaximumLinearImpulse() const HK_OVERRIDE;

        /// Sets the maximum angular impulse the solver is allowed to apply to maintain this constraint.
        virtual void setMaximumAngularImpulse(hkReal maxAngularImpulse) HK_OVERRIDE;

        /// Gets the maximum angular impulse that can be applied by this constraint.
        virtual hkReal getMaximumAngularImpulse() const HK_OVERRIDE;

        /// Choose the body to be notified when the constraint's maximum impulse is breached.
        virtual void setBodyToNotify(int bodyIdx) HK_OVERRIDE;

        /// Returns the index of the body that is notified when the constraint's maximum impulse is breached.
        virtual hkUint8 getNotifiedBodyIndex() const HK_OVERRIDE;

        /// Sets the solving method for this constraint. Use one of the hkpConstraintAtom::SolvingMethod as a value for method.
        virtual void setSolvingMethod(hkpConstraintAtom::SolvingMethod method) HK_OVERRIDE;

        /// Gets the inertia stabilization factor, returns HK_FAILURE if the factor is not defined for the given constraint.
        virtual hkResult getInertiaStabilizationFactor( _Out_ hkReal& inertiaStabilizationFactorOut ) const HK_OVERRIDE;

        /// Sets the inertia stabilization factor, return HK_FAILURE if the factor is not defined for the given constraint.
        virtual hkResult setInertiaStabilizationFactor(const hkReal inertiaStabilizationFactorIn) HK_OVERRIDE;

        virtual void getRuntimeInfo( hkBool wantRuntime, hkpConstraintData::RuntimeInfo& infoOut ) const HK_OVERRIDE;

        /// Returns the linear impulse applied by the solver
        virtual void getAppliedLinearImpulse( const hkTransform& worldFromBodyA, const hkTransform& worldFromBodyB,
            _In_ const struct hkpConstraintRuntime* runtime, _Out_ hkVector4& impulseOut ) const HK_OVERRIDE;

    public:

        Atoms m_atoms;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
