// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0



inline hkReal hkp6DofConstraintData::getTwistMinAngularLimit() const
{
    return m_blueprints.m_twistLimit.m_minAngle;
}

inline hkReal hkp6DofConstraintData::getTwistMaxAngularLimit() const
{
    return m_blueprints.m_twistLimit.m_maxAngle;
}

inline hkReal hkp6DofConstraintData::getSwing0Limit() const
{
    return m_blueprints.m_ellipticalLimit.m_angle0;
}

inline hkReal hkp6DofConstraintData::getSwing1Limit() const
{
    return m_blueprints.m_ellipticalLimit.m_angle1;
}

inline hkReal hkp6DofConstraintData::getConeAngularLimit() const
{
    return 0;
}

inline hkBool hkp6DofConstraintData::getConeLimitStabilization() const
{
    return 0;
}

inline hkReal hkp6DofConstraintData::getMaxFrictionTorque() const
{
    return m_blueprints.m_angFrictions[0].m_maxFrictionTorque;
}

inline void hkp6DofConstraintData::setAngularLimitsTauFactor( hkReal mag )
{
    m_blueprints.m_twistLimit.m_angularLimitsTauFactor        = (float)mag;
    m_blueprints.m_ellipticalLimit.m_angularLimitsTauFactor   = (float)mag;
}

inline hkReal hkp6DofConstraintData::getAngularLimitsTauFactor() const
{
    if (m_blueprints.m_twistLimit.m_angularLimitsTauFactor != m_blueprints.m_ellipticalLimit.m_angularLimitsTauFactor )
    {
        HK_WARN(0xad6ddbbd, "TauFactor for varies for individual limits of a hknp6DofConstraintData");
    }

    return m_blueprints.m_twistLimit.m_angularLimitsTauFactor;
}

inline bool hkp6DofConstraintData::areAngularMotorsEnabled() const
{
    return m_blueprints.m_ragdollMotors.m_isEnabled;
}

bool hkp6DofConstraintData::isLinearMotorEnabled( int axis ) const
{
    HK_ASSERT_NO_MSG( 0xf0fc34cd, axis>=0 && axis < 3);
    return m_blueprints.linearMotor(axis).m_isEnabled;
}

hkpConstraintMotor* hkp6DofConstraintData::getLinearMotor( int axis ) const
{
    HK_ASSERT_NO_MSG( 0xf0fc34cd, axis>=0 && axis < 3);
    return m_blueprints.linearMotor(axis).m_motor;
}

hkReal hkp6DofConstraintData::getLinearLimit() const
{
    return m_blueprints.m_stiffSpring.m_maxLength;
}

/// Function to get the solver results for a specific DOF.
/// Note since this constraint data builds a dynamic list of atoms, you have to use this function to extract
/// a specific value.
hkpSolverResults& hkp6DofConstraintData::Runtime::get( Result::Enum type, _In_ hkp6DofConstraintData* data )
{
    if ( data->m_resultToRuntime[type] >=0 )
    {
        return m_solverResults[ data->m_resultToRuntime[type] ];
    }
    return data->s_unusedSolverResults;
}

/// const version
const hkpSolverResults& hkp6DofConstraintData::Runtime::get( Result::Enum type, _In_ const hkp6DofConstraintData* data ) const
{
    if ( data->m_resultToRuntime[type] >=0 )
    {
        return m_solverResults[ data->m_resultToRuntime[type] ];
    }
    return data->s_unusedSolverResults;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
