// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Atom/hkpConstraintAtom.h>
#include <Physics/ConstraintSolver/Constraint/hkpConstraintQueryIn.h>
#include <Physics/ConstraintSolver/Constraint/hkpConstraintQueryOut.h>

class hkpConstraintData;

// Function prototype for Jacobian builders
typedef void (HK_CALL *hkpConstraintAtomBuildJacobianFunc) ( hkpConstraintData* m_constraintData, const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out );


/// Special atom used to implement a custom atomic constraint that generates its Jacobians calling the buildJacobian()
/// function in the hkpConstraintData member.
struct HK_EXPORT_PHYSICS hkpBridgeConstraintAtom : public hkpConstraintAtom
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT, hkpBridgeConstraintAtom );
        HK_DECLARE_REFLECTION();
        HKP_DECLARE_CONSTRAINTATOM_NEXT();

        hkpBridgeConstraintAtom() : hkpConstraintAtom( TYPE_BRIDGE ) {}

        void afterReflectNew();

        // call this to do stuff not done in the constructor yet
        void init( _In_ hkpConstraintData* m_constraintData );

        // bridge atoms are always the last atom, so no need to increment solver result, just make sure the
        // program crashes if the result of this function is used
        HK_INLINE int numSolverResults() const { return 100000; }

        // addToConstraintInfo() not needed

    public:

        hkpConstraintAtomBuildJacobianFunc m_buildJacobianFunc; //+nosave +overridetype(void*)

        hkViewPtr<hkpConstraintData> m_constraintData;
};


//
struct HK_EXPORT_PHYSICS hkpBridgeAtoms
{
    public:

        HK_DECLARE_REFLECTION();
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT, hkpBridgeAtoms );

        hkpBridgeAtoms() {}

        // get a pointer to the first atom
        _Ret_notnull_ const hkpConstraintAtom* getAtoms() const { return &m_bridgeAtom; }

        // get the size of all atoms (we can't use sizeof(*this) because of align16 padding)
        int getSizeOfAllAtoms() const { return hkGetByteOffsetInt(this, &m_bridgeAtom+1); }

    public:

        HK_ALIGN_REAL(hkpBridgeConstraintAtom m_bridgeAtom);
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
