// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Geometry/Internal/hkcdInternal.h>
#include <Common/Base/UnitTest/hkUnitTest.h>

#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>
#include <Geometry/Collide/Types/hkcdRay.h>
#include <Geometry/Internal/Algorithms/Gsk/hkcdGsk.h>

static void gskLinearCastTest()
{
    hkPseudoRandomGenerator rand(1234);

    for (int i = 0; i < 100 /* *1000 */; i++)
    {
        const int numVerts = 16;
        hkcdVertex shapeA[numVerts];
        for (int x = 0; x < numVerts; x++)
        {
            hkVector4 v; rand.getRandomVector11(v);
            shapeA[x].assign( v, x );
        }
        hkcdVertex shapeB[numVerts];
        for (int x = 0; x < numVerts; x++)
        {
            hkVector4 v; rand.getRandomVector11(v);
            shapeB[x].assign( v, x );
        }

        for (int j = 0; j < 100; j++)
        {
            hkVector4 pos; rand.getRandomVector11(pos);
            pos.normalize<3>(); pos *= hkSimdReal_4;    // position outside

            hkcdGsk::LinearCastInput input(0,0);
            input.m_bTa.setIdentity();
            input.m_from = pos;
            input.m_direction = -pos;

            hkcdGsk::LinearCastOutput output;
            output.m_fractionInOut = hkSimdReal_1;
            bool hasHit = hkcdGsk::linearCast(shapeA, numVerts, shapeB, numVerts, input, output);

            HK_TEST(hasHit);
            if ( hasHit )
            {
                hkSimdReal dot = output.m_normalInA.dot<3>(input.m_direction);
                HK_TEST(dot < hkSimdReal_0);

                // check distance at the hit
                hkcdGsk::Cache cache; cache.init();
                hkcdGsk::GetClosestPointInput gcpInput;
                gcpInput.m_bTa.setIdentity();
                gcpInput.m_bTa.getTranslation().setAddMul(input.m_from, input.m_direction, output.m_fractionInOut);

                hkcdGsk::GetClosestPointOutput gcpOut;
                hkcdGsk::getClosestPoint(shapeA, numVerts, shapeB, numVerts, gcpInput, &cache, gcpOut);
                hkSimdReal distance; distance.setAbs(gcpOut.m_distance);
                HK_TEST(distance < hkSimdReal::fromFloat(0.05f));
            }


            if ( j < 10 )   // reduced number of tests, since these test are way more expensive
            {
                {   // now use start point collector
                    output.m_fractionInOut = hkSimdReal_1;
                    hkcdGsk::LinearCastOutput startPoint;
                    hkcdGsk::linearCast( shapeA, numVerts, shapeB, numVerts, input, output, &startPoint );

                    //
                    //  Get closest point
                    //
                    hkcdGsk::Cache cache; cache.init();
                    hkcdGsk::GetClosestPointInput gcpInput;     gcpInput.m_bTa.setIdentity(); gcpInput.m_bTa.setTranslation( input.m_from );

                    hkcdGsk::GetClosestPointOutput gcpOut;
                    hkcdGsk::getClosestPoint( shapeA, numVerts, shapeB, numVerts, gcpInput, &cache, gcpOut );

                    HK_TEST( gcpOut.m_distance.approxEqual( startPoint.m_fractionInOut, hkSimdReal::fromFloat( .01f ) ) );
                    HK_TEST( gcpOut.m_normalInA.allEqual<3>( startPoint.m_normalInA, hkSimdReal::fromFloat( .01f ) ) );
                }



                // check inside position
                input.m_from.setZero();

                output.m_fractionInOut = hkSimdReal_1;
                hkcdGsk::LinearCastOutput startPoint; startPoint.m_fractionInOut = hkSimdReal_15;
                hasHit = hkcdGsk::linearCast( shapeA, numVerts, shapeB, numVerts, input, output, &startPoint );
                {
                    // check distance at the hit
                    hkcdGsk::Cache cache; cache.init();
                    hkcdGsk::GetClosestPointInput gcpInput;     gcpInput.m_bTa.setIdentity();

                    hkcdGsk::GetClosestPointOutput gcpOut;
                    hkcdGsk::getClosestPoint( shapeA, numVerts, shapeB, numVerts, gcpInput, &cache, gcpOut );

                    HK_TEST( gcpOut.m_distance < hkSimdReal_0 || output.m_fractionInOut > hkSimdReal_0 );

                    HK_TEST( gcpOut.m_distance.approxEqual( startPoint.m_fractionInOut, hkSimdReal::fromFloat(.01f) ) );
                    HK_TEST( gcpOut.m_normalInA.allEqual<3>( startPoint.m_normalInA   , hkSimdReal::fromFloat(.01f) ) );


                    hkSimdReal dot = gcpOut.m_normalInA.dot<3>( input.m_direction );
                    if ( hasHit )
                    {
                        HK_TEST( dot < hkSimdReal_0 );
                    }
                    else
                    {
                        HK_TEST( dot > hkSimdReal_0 );
                    }
                }
            }
        }
    }

}

int GskUnitTest_main()
{
    gskLinearCastTest();
    return 0;
}

HK_TEST_REGISTER(GskUnitTest_main, "Fast", "Geometry/Test/UnitTest/Internal/", __FILE__ );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
