// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

//
HK_INLINE void  hkcdFourAabb::setEmpty()
{
    m_lx.setConstant<HK_QUADREAL_MAX>();
    m_ly.setConstant<HK_QUADREAL_MAX>();
    m_lz.setConstant<HK_QUADREAL_MAX>();
    m_hx.setConstant<HK_QUADREAL_MINUS_MAX>();
    m_hy.setConstant<HK_QUADREAL_MINUS_MAX>();
    m_hz.setConstant<HK_QUADREAL_MINUS_MAX>();
}

//
HK_INLINE void  hkcdFourAabb::getAabb(int index, _Inout_ hkAabb* HK_RESTRICT aabb) const
{
    aabb->m_min.set( m_lx( index ), m_ly( index ), m_lz( index ), 0 );
    aabb->m_max.set( m_hx( index ), m_hy( index ), m_hz( index ), 0 );
}

//
HK_INLINE void  hkcdFourAabb::getCompoundAabb(_Inout_ hkAabb* HK_RESTRICT aabb) const
{
    hkVector4 a = m_hx;     hkVector4 b = m_hy;
    hkVector4 c = m_hz;     hkVector4 d = hkVec4_0;
    hkMath::transpose( a, b, c, d );

    a.setMax( a, b );
    c.setMax( c, d );
    aabb->m_max.setMax( a, c );

    a = m_lx; b = m_ly; c = m_lz;   d = hkVec4_0;
    hkMath::transpose( a, b, c, d );
    a.setMin( a, b );
    c.setMin( c, d );
    aabb->m_min.setMin( a, c );
}

//
template<int INDEX>
HK_INLINE void  hkcdFourAabb::getAabb(_Inout_ hkAabb* HK_RESTRICT aabb) const
{
    aabb->m_min.set(m_lx.getComponent<INDEX>(), m_ly.getComponent<INDEX>(), m_lz.getComponent<INDEX>(), hkSimdReal_0);
    aabb->m_max.set(m_hx.getComponent<INDEX>(), m_hy.getComponent<INDEX>(), m_hz.getComponent<INDEX>(), hkSimdReal_0);
}

//
HK_INLINE void  hkcdFourAabb::setAllAabbs(const hkAabb& aabb0, const hkAabb& aabb1, const hkAabb& aabb2, const hkAabb& aabb3)
{
    m_lx.set(aabb0.m_min.getComponent<0>(), aabb1.m_min.getComponent<0>(), aabb2.m_min.getComponent<0>(), aabb3.m_min.getComponent<0>());
    m_hx.set(aabb0.m_max.getComponent<0>(), aabb1.m_max.getComponent<0>(), aabb2.m_max.getComponent<0>(), aabb3.m_max.getComponent<0>());
    m_ly.set(aabb0.m_min.getComponent<1>(), aabb1.m_min.getComponent<1>(), aabb2.m_min.getComponent<1>(), aabb3.m_min.getComponent<1>());
    m_hy.set(aabb0.m_max.getComponent<1>(), aabb1.m_max.getComponent<1>(), aabb2.m_max.getComponent<1>(), aabb3.m_max.getComponent<1>());
    m_lz.set(aabb0.m_min.getComponent<2>(), aabb1.m_min.getComponent<2>(), aabb2.m_min.getComponent<2>(), aabb3.m_min.getComponent<2>());
    m_hz.set(aabb0.m_max.getComponent<2>(), aabb1.m_max.getComponent<2>(), aabb2.m_max.getComponent<2>(), aabb3.m_max.getComponent<2>());
}

//
HK_INLINE void  hkcdFourAabb::setAabb(int index, const hkAabb& aabb)
{
    m_lx( index ) = aabb.m_min( 0 ); m_hx( index ) = aabb.m_max(0);
    m_ly( index ) = aabb.m_min( 1 ); m_hy( index ) = aabb.m_max(1);
    m_lz( index ) = aabb.m_min( 2 ); m_hz( index ) = aabb.m_max(2);
}

//
template <int INDEX>
HK_INLINE void  hkcdFourAabb::setAabb(const hkAabb& aabb)
{
    m_lx.setComponent<INDEX>(aabb.m_min.getComponent<0>()); m_hx.setComponent<INDEX>(aabb.m_max.getComponent<0>());
    m_ly.setComponent<INDEX>(aabb.m_min.getComponent<1>()); m_hy.setComponent<INDEX>(aabb.m_max.getComponent<1>());
    m_lz.setComponent<INDEX>(aabb.m_min.getComponent<2>()); m_hz.setComponent<INDEX>(aabb.m_max.getComponent<2>());
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
