// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Geometry/Collide/Types/hkcdRay.h>

/// Four AABBs
struct HK_EXPORT_COMMON hkcdFourAabb
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_COLLIDE,hkcdFourAabb);
    HK_DECLARE_REFLECTION();

    hkcdFourAabb(const hkcdFourAabb& other)
    {
        m_lx.set(other.m_lx);
        m_hx.set(other.m_hx);
        m_ly.set(other.m_ly);
        m_hy.set(other.m_hy);
        m_lz.set(other.m_lz);
        m_hz.set(other.m_hz);
    }
    enum BoundIndex
    {
        X_MIN   =   0,  ///< Index of the lower bounds about the X axis.
        X_MAX   =   1,  ///< Index of the upper bounds about the X axis.
        Y_MIN   =   2,  ///< Index of the lower bounds about the Y axis.
        Y_MAX   =   3,  ///< Index of the upper bounds about the Y axis.
        Z_MIN   =   4,  ///< Index of the lower bounds about the Z axis.
        Z_MAX   =   5   ///< Index of the upper bounds about the Z axis.
    };

    /// ctor.
    HK_INLINE           hkcdFourAabb() {}

    /// Set empty.
    HK_INLINE void  setEmpty();

    /// Get one AABB at a given index.
    HK_INLINE void  getAabb(int index, _Inout_ hkAabb* HK_RESTRICT aabb) const;

    /// Get the union of the four AABBs.
    HK_INLINE void  getCompoundAabb(_Inout_ hkAabb* HK_RESTRICT aabb) const;

    /// Get one AABB at a given index.
    template <int INDEX>
    HK_INLINE void  getAabb(_Inout_ hkAabb* HK_RESTRICT aabb) const;

    /// Set all AABB.
    HK_INLINE void  setAllAabbs(const hkAabb& aabb0, const hkAabb& aabb1, const hkAabb& aabb2, const hkAabb& aabb3);

    /// Set one AABB at a given index.
    HK_INLINE void  setAabb(int index, const hkAabb& aabb);

    /// Set one AABB at a given index.
    template <int INDEX>
    HK_INLINE void  setAabb(const hkAabb& aabb);

    hkVector4   m_lx, m_hx; ///< Lower and upper bounds along the X axis.
    hkVector4   m_ly, m_hy; ///< Lower and upper bounds along the Y axis.
    hkVector4   m_lz, m_hz; ///< Lower and upper bounds along the Z axis.
};

#include <Geometry/Internal/Types/hkcdFourAabb.inl>

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
