// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

//
struct HK_EXPORT_COMMON Serializer
{
    /// Serialization ids (see hkStructuredBinaryStream).
    enum SerializationIDS
    {
        BID_TREE    =   0,
            VID_DOMAIN  =   1,
            AID_NODES   =   2,

        END_OF_IDS
    };

    /// Save tree.
    template <typename WRITER>
    static void save(const Tree& tree, WRITER& writer)
    {
        writer.openBranch(BID_TREE);
            writer.writeData((const STORAGE&)tree);
            writer.writeValue(tree.m_domain, VID_DOMAIN);
        writer.close();
    }

    /// Load tree.
    template <typename READER>
    static void load(Tree& tree, READER& reader)
    {
        reader.enter(BID_TREE);
            reader.readData((STORAGE&)tree);
            reader.readValue(tree.m_domain, VID_DOMAIN);
        reader.leave();
    }

    /// Save STORAGE.
    template <typename WRITER>
    static void save(const STORAGE& storage, WRITER& writer) { writer.writeArray(storage.m_nodes, AID_NODES); }

    /// Load STORAGE.
    template <typename READER>
    static void load(STORAGE& storage, READER& reader) { reader.readArray(storage.m_nodes, AID_NODES); }

    /// Default save.
    template <typename T, typename WRITER>
    static void save(const T& value, WRITER& writer) { value.save(writer); }

    /// Default load.
    template <typename T, typename READER>
    static void load(T& value, READER& reader) { value.load(reader); }
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
