// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once


#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED) && \
    ( (defined(HK_PLATFORM_WIN32) && !defined(HK_ARCH_ARM)) || defined(HK_PLATFORM_LINUX) || defined(HK_PLATFORM_PSVITA) || defined(HK_PLATFORM_PS4) || defined(HK_PLATFORM_DURANGO))
    // Use standard SIMD unpack.
#else
    // Use FPU based unpack for platforms with poor or no SIMD support.
    #define HKCD_STATIC_TREE_CODECS_USE_FPU
#endif

#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Math/Vector/hkIntVector.h>

    // Note about COM-1787:
    // Due to rounding difference between platform with and without FMA,
    // parent AABB extents are divided by 226 instead of 225 to ensure proper decoding regardless of the platform.

namespace hkcdStaticTree
{
    /// 3 Axis CODEC, generate ~8% traversal cost increase.
    struct HK_EXPORT_COMMON Codec3Axis
    {
        HK_DECLARE_CLASS(Codec3Axis, New, Pod, Reflect);

        /// Pack a child AABB wrt. its parent.
        static void HK_CALL         pack(const hkAabb& parent, const hkAabb& child, Codec3Axis& nodeOut);

        /// Unpack a child AABB wrt. its parent.
        static void HK_CALL         unpack(const hkAabb& parent, const Codec3Axis& child, hkAabb& aabbOut);

        #if 0 // Scalar unpack used only to debug / research.
        /// Unpack two child.
        static HK_INLINE void unpackScalar(const hkAabb& parent, const hkVector4& scale, const Codec3Axis& child, hkAabb& aabbOut)
        {
            hkReal      minXsq = (hkReal) (child.m_xyz[0] >> 4); minXsq *= minXsq;
            hkReal      minYsq = (hkReal) (child.m_xyz[1] >> 4); minYsq *= minYsq;
            hkReal      minZsq = (hkReal) (child.m_xyz[2] >> 4); minZsq *= minZsq;

            aabbOut.m_min(0) = parent.m_min(0) + scale(0) * minXsq;
            aabbOut.m_min(1) = parent.m_min(1) + scale(1) * minYsq;
            aabbOut.m_min(2) = parent.m_min(2) + scale(2) * minZsq;

            hkReal      maxXsq = (hkReal) (child.m_xyz[0] & 15); maxXsq *= maxXsq;
            hkReal      maxYsq = (hkReal) (child.m_xyz[1] & 15); maxYsq *= maxYsq;
            hkReal      maxZsq = (hkReal) (child.m_xyz[2] & 15); maxZsq *= maxZsq;

            aabbOut.m_max(0) = parent.m_max(0) - scale(0) * maxXsq;
            aabbOut.m_max(1) = parent.m_max(1) - scale(1) * maxYsq;
            aabbOut.m_max(2) = parent.m_max(2) - scale(2) * maxZsq;
        }

        /// Unpack two child.
        static HK_INLINE void unpackScalar(const hkAabb& parent, const Codec3Axis& childA, const Codec3Axis& childB, hkAabb& aabbOutA, hkAabb& aabbOutB)
        {
            hkVector4   extent; extent.setSub(parent.m_max, parent.m_min); extent.mul(hkSimdReal::getConstant<HK_QUADREAL_INV_226>());
            unpackScalar(parent, extent, childA, aabbOutA);
            unpackScalar(parent, extent, childB, aabbOutB);
        }
        #endif

        /// Unpack two child.
        static HK_INLINE void unpack(const hkAabb& parent, const Codec3Axis& childA, const Codec3Axis& childB, hkAabb& aabbOutA, hkAabb& aabbOutB)
        {
            HK_ASSERT(0xF9ACFCA1, ((&parent) != (&aabbOutA)) && ((&parent) != (&aabbOutB)), "Aliasing detected.");
            hkVector4   extent;
            extent.setSub(parent.m_max, parent.m_min);
            extent.mul(hkSimdReal::getConstant<HK_QUADREAL_INV_226>());

#if defined(HKCD_STATIC_TREE_CODECS_USE_FPU)

            int minAx = childA.m_xyz[0] >> 4, maxAx = childA.m_xyz[0] & 0xf;
            int minAy = childA.m_xyz[1] >> 4, maxAy = childA.m_xyz[1] & 0xf;
            int minAz = childA.m_xyz[2] >> 4, maxAz = childA.m_xyz[2] & 0xf;
            int minBx = childB.m_xyz[0] >> 4, maxBx = childB.m_xyz[0] & 0xf;
            int minBy = childB.m_xyz[1] >> 4, maxBy = childB.m_xyz[1] & 0xf;
            int minBz = childB.m_xyz[2] >> 4, maxBz = childB.m_xyz[2] & 0xf;

            aabbOutA.m_min.setZero();
            aabbOutA.m_max.setZero();
            aabbOutA.m_min(0) = parent.m_min(0) + extent(0) * hkReal(minAx * minAx);
            aabbOutA.m_min(1) = parent.m_min(1) + extent(1) * hkReal(minAy * minAy);
            aabbOutA.m_min(2) = parent.m_min(2) + extent(2) * hkReal(minAz * minAz);
            aabbOutA.m_max(0) = parent.m_max(0) - extent(0) * hkReal(maxAx * maxAx);
            aabbOutA.m_max(1) = parent.m_max(1) - extent(1) * hkReal(maxAy * maxAy);
            aabbOutA.m_max(2) = parent.m_max(2) - extent(2) * hkReal(maxAz * maxAz);

            aabbOutB.m_min.setZero();
            aabbOutB.m_max.setZero();
            aabbOutB.m_min(0) = parent.m_min(0) + extent(0) * hkReal(minBx * minBx);
            aabbOutB.m_min(1) = parent.m_min(1) + extent(1) * hkReal(minBy * minBy);
            aabbOutB.m_min(2) = parent.m_min(2) + extent(2) * hkReal(minBz * minBz);
            aabbOutB.m_max(0) = parent.m_max(0) - extent(0) * hkReal(maxBx * maxBx);
            aabbOutB.m_max(1) = parent.m_max(1) - extent(1) * hkReal(maxBy * maxBy);
            aabbOutB.m_max(2) = parent.m_max(2) - extent(2) * hkReal(maxBz * maxBz);

#else


#if 1
            hkIntVector bitsA; bitsA.load<1, HK_IO_BYTE_ALIGNED>((const hkUint32*)childA.m_xyz); bitsA.setSplit8To32(bitsA);
            hkIntVector bitsB; bitsB.load<1, HK_IO_BYTE_ALIGNED>((const hkUint32*)childB.m_xyz); bitsB.setSplit8To32(bitsB);
#else
            hkIntVector bitsA;
            hkIntVector bitsB;

    #if defined(HK_REAL_IS_DOUBLE) || defined(HK_PLATFORM_PSVITA)
            // Neon can't do a byte-aligned load, but copying is still better than the FPU version
            HK_ALIGN_REAL(Codec3Axis copyOfchildA) = childA;
            HK_ALIGN_REAL(Codec3Axis copyOfchildB) = childB;
            bitsA.load<1>((const hkUint32*) copyOfchildA.m_xyz);
            bitsB.load<1>((const hkUint32*) copyOfchildB.m_xyz);
    #else
            hkVector4   simdA; simdA.load<1,HK_IO_BYTE_ALIGNED>((const hkReal*)childA.m_xyz);
            hkVector4   simdB; simdB.load<1,HK_IO_BYTE_ALIGNED>((const hkReal*)childB.m_xyz);
            bitsA.loadAsFloat32BitRepresentation(simdA);
            bitsB.loadAsFloat32BitRepresentation(simdB);
    #endif

            bitsA.setSplit8To32(bitsA);
            bitsB.setSplit8To32(bitsB);
#endif
            hkIntVector iminA; iminA.setShiftRight32<4>(bitsA);
            hkIntVector iminB; iminB.setShiftRight32<4>(bitsB);

            hkIntVector imaxA; imaxA.setAnd(bitsA, v_mask);
            hkIntVector imaxB; imaxB.setAnd(bitsB, v_mask);

            hkVector4   minA; iminA.convertS32ToF32(minA); minA.mul(minA);
            hkVector4   maxA; imaxA.convertS32ToF32(maxA); maxA.mul(maxA);
            hkVector4   minB; iminB.convertS32ToF32(minB); minB.mul(minB);
            hkVector4   maxB; imaxB.convertS32ToF32(maxB); maxB.mul(maxB);

            aabbOutA.m_min.setAddMul(parent.m_min, extent, minA);
            aabbOutA.m_max.setSubMul(parent.m_max, extent, maxA);
            aabbOutB.m_min.setAddMul(parent.m_min, extent, minB);
            aabbOutB.m_max.setSubMul(parent.m_max, extent, maxB);

#endif

            #if 0 //defined(HK_DEBUG)
            {
                // Use scalar version to check results.
                hkAabb  aabbCheckA,aabbCheckB; unpackScalar(parent, childA, childB, aabbCheckA, aabbCheckB);
                HK_ASSERT(0xFD3BD8D9,   aabbCheckA.m_min.equal(aabbOutA.m_min).allAreSet(hkVector4ComparisonMask::MASK_XYZ) &&
                    aabbCheckA.m_max.equal(aabbOutA.m_max).allAreSet(hkVector4ComparisonMask::MASK_XYZ) &&
                    aabbCheckB.m_min.equal(aabbOutB.m_min).allAreSet(hkVector4ComparisonMask::MASK_XYZ) &&
                    aabbCheckB.m_max.equal(aabbOutB.m_max).allAreSet(hkVector4ComparisonMask::MASK_XYZ), "Internal unpack error");
        }
            #endif
        }

        /// Save to a structured binary stream.
        template <typename WRITER>
        inline void                 save(WRITER& writer) const { writer.writeData(m_xyz, 3); }

        /// Load from a structured binary stream.
        template <typename READER>
        inline void                 load(READER& reader) { reader.readData(m_xyz, 3); }

        hkUint8     m_xyz[3];   ///< XYZ mins and maxs 4 bits fractions.

        static const HK_ALIGN16(hkUint32 s_mask[4]);
        static const hkIntVector    v_mask;
    };

    /// 4 bytes CODEC derived from Codec3Axis, 7 bits data range / leaves count.
    struct HK_EXPORT_COMMON Codec3Axis4 : public Codec3Axis
    {
        HK_DECLARE_CLASS(Codec3Axis4, New, Pod, Reflect);

        enum { DATA_BITS = 7 };

        /// Return true if this node is internal.
        HK_INLINE hkBool32  isInternal() const { return m_data&1; }

        /// Set right child index delta.
        HK_INLINE void      setDelta(int delta) { m_data = (hkUint8)(delta | 1); HK_ASSERT(0x49273727, (delta&1) == 0 && getDelta() == delta, "Delta overflow"); }

        /// Return node delta.
        HK_INLINE int           getDelta() const { HK_ASSERT(0x49273727, isInternal(), "Node is not internal"); return m_data&0xfe; }

        /// Set leaf data.
        HK_INLINE void      setData(int data) { m_data = (hkUint8)(data<<1); HK_ASSERT(0x49273727, getData() == data, "Data overflow"); }

        /// Return node data.
        HK_INLINE int           getData() const { HK_ASSERT(0x49273727, !isInternal(), "Node is not a leaf"); return m_data>>1; }

        /// Save to a structured binary stream.
        template <typename WRITER>
        inline void                 save(WRITER& writer) const { Codec3Axis::save(writer); writer.writeData(m_data); }

        /// Load from a structured binary stream.
        template <typename READER>
        inline void                 load(READER& reader) { Codec3Axis::load(reader); reader.readData(m_data); }

        hkUint8     m_data;     ///< Data or right child.
    };

    /// 5 bytes CODEC derived from Codec3Axis, 15 bits data range / leaves count.
    struct HK_EXPORT_COMMON Codec3Axis5 : public Codec3Axis
    {
        HK_DECLARE_CLASS(Codec3Axis5, New, Pod, Reflect);

        enum { DATA_BITS = 15 };

        /// Return true if this node is internal.
        HK_INLINE hkBool32  isInternal() const { return m_hiData&0x80; }

        /// Set right child index delta.
        HK_INLINE void      setDelta(int delta) { const int odd(delta>>1); m_hiData = (hkUint8)(0x80 | (odd>>8)); m_loData = (hkUint8)odd; HK_ASSERT(0x49273727, (delta&1) == 0 && getDelta() == delta, "Delta overflow"); }

        /// Return node delta.
        HK_INLINE int           getDelta() const { HK_ASSERT(0x49273727, isInternal(), "Node is not internal"); return (((int)(m_hiData & 0x7f)) << 8 | m_loData) << 1; }

        /// Set leaf data.
        HK_INLINE void      setData(int data) { m_hiData = (hkUint8)(0x7f & (data>>8)); m_loData = (hkUint8)data;   HK_ASSERT(0x49273727, getData() == data, "Data overflow"); }

        /// Return node data.
        HK_INLINE int           getData() const { HK_ASSERT(0x49273727, !isInternal(), "Node is not a leaf"); return (((int)m_hiData)<<8) | m_loData; }

        /// Save to a structured binary stream.
        template <typename WRITER>
        inline void                 save(WRITER& writer) const { Codec3Axis::save(writer); writer.writeData(m_hiData); writer.writeData(m_loData); }

        /// Load from a structured binary stream.
        template <typename READER>
        inline void                 load(READER& reader) { Codec3Axis::load(reader); reader.readData(m_hiData); reader.readData(m_loData); }

        hkUint8     m_hiData;   ///< Data high.
        hkUint8     m_loData;   ///< Data low.
    };

    /// 6 bytes CODEC derived from Codec3Axis, 23 bits data range / leaves count.
    struct HK_EXPORT_COMMON Codec3Axis6 : public Codec3Axis
    {
        HK_DECLARE_CLASS(Codec3Axis6, New, Pod, Reflect);

        enum { DATA_BITS = 23 };

        /// Return true if this node is internal.
        HK_INLINE hkBool32  isInternal() const { return m_hiData&0x80; }

        /// Set right child index delta.
        HK_INLINE void      setDelta(int delta) { const int odd(delta>>1); m_hiData = (hkUint8)(0x80 | (odd>>16)); m_loData = (hkUint16)odd; HK_ASSERT(0x49273727, (delta&1) == 0 && getDelta() == delta, "Delta overflow"); }

        /// Return node delta.
        HK_INLINE int           getDelta() const { HK_ASSERT(0x49273727, isInternal(), "Node is not internal"); return (((int)(m_hiData & 0x7f)) << 16 | m_loData) << 1; }

        /// Set leaf data.
        HK_INLINE void      setData(int data) { m_hiData = (hkUint8)(0x7f & (data>>16)); m_loData = (hkUint16)data; HK_ASSERT(0x49273727, getData() == data, "Data overflow"); }

        /// Return node data.
        HK_INLINE int           getData() const { HK_ASSERT(0x49273727, !isInternal(), "Node is not a leaf"); return (((int)m_hiData)<<16) | m_loData; }

        /// Save to a structured binary stream.
        template <typename WRITER>
        inline void                 save(WRITER& writer) const { Codec3Axis::save(writer); writer.writeData(m_hiData); writer.writeData(m_loData); }

        /// Load from a structured binary stream.
        template <typename READER>
        inline void                 load(READER& reader) { Codec3Axis::load(reader); reader.readData(m_hiData); reader.readData(m_loData); }

        hkUint8     m_hiData;   ///< Data high.
        hkUint16    m_loData;   ///< Data low.
    };

    /// 32 bytes raw CODEC, full precision AABB in absolute coordinate. 23 bits data range / leaves count.
    struct HK_EXPORT_COMMON CodecRaw
    {
        HK_DECLARE_CLASS(CodecRaw, New, Pod, Reflect);

        enum { DATA_BITS = 23 };

        /// Pack.
        static HK_INLINE void pack(const hkAabb&, const hkAabb& child, CodecRaw& nodeOut) { nodeOut.m_aabb = child; }

        /// Unpack a child AABB.
        static HK_INLINE void unpack(const hkAabb&, const CodecRaw& child, hkAabb& aabbOut) { aabbOut = child.m_aabb; }

        /// Unpack two children AABBs.
        static HK_INLINE void unpack(const hkAabb& parent, const CodecRaw& childA, const CodecRaw& childB, hkAabb& aabbOutA, hkAabb& aabbOutB) { unpack(parent, childA, aabbOutA); unpack(parent, childB, aabbOutB); }

        /// Return true if this node is internal.
        HK_INLINE hkBool32  isInternal() const { return getRawData() & 1; }

        /// Set right child index delta.
        HK_INLINE void      setDelta(int delta) { setRawData(delta|1); HK_ASSERT(0x49273727, (delta&1) == 0 && getDelta() == delta, "Delta overflow"); }

        /// Return node delta.
        HK_INLINE int           getDelta() const { HK_ASSERT(0x49273727, isInternal(), "Node is not internal"); return getRawData() & (~1); }

        /// Set leaf data.
        HK_INLINE void      setData(int data) { setRawData(data<<1); HK_ASSERT(0x49273727, getData() == data, "Data overflow"); }

        /// Return node data.
        HK_INLINE int           getData() const { HK_ASSERT(0x49273727, !isInternal(), "Node is not a leaf"); return getRawData() >> 1; }

        /// Save to a structured binary stream.
        template <typename WRITER>
        inline void                 save(WRITER& writer) const { writer.writeData(m_aabb); }

        /// Load from a structured binary stream.
        template <typename READER>
        inline void                 load(READER& reader) { reader.readData(m_aabb); }

    private:

        /// Return the raw data value.
        HK_INLINE int           getRawData() const { return m_aabb.m_min.getInt24W(); }

        /// Set the raw data value.
        HK_INLINE void      setRawData(int data) { return m_aabb.m_min.setInt24W(data); }

    public:

        hkAabb      m_aabb;     ///< AABB and data in m_min:W
    };
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
