// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#include <Geometry/Internal/Algorithms/TreeQueries/hkcdAabbTreeQueries.h>

    /// Bounding volume tree that can't be updated.
    /// It is built from an hkcdDynamicAabbTree, then optimized for data size.
class HK_EXPORT_COMMON hkcdStaticAabbTree : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(hkcdStaticAabbTree, New, Reflect);
    HK_RECORD_ATTR(hk::Version(2));

    class Impl;
    typedef hkUint32 TreeHandle;

    hkcdStaticAabbTree();
    
    virtual ~hkcdStaticAabbTree();

        /// Construct the static tree from an existing hkcdDynamicAabbTree.
        /// Note that this does not optimize the layout of the tree; hkcdDynamicAabbTree::rebuild should be called first.
    void buildFromDynamicTree(_In_ const class hkcdDynamicAabbTree* dynTree);

        /// Cast a ray through the tree. The collector's callback is triggered for each leaf in the tree that is hit
    hkBool32 castRay( hkVector4Parameter start, hkVector4Parameter end, _Inout_ hkcdAabbTreeQueries::RaycastCollector* collector) const;

        /// Cast a ray through the tree. The collector's callback is triggered for each leaf in the tree that is hit
    hkBool32 castSphere( hkVector4Parameter start, hkVector4Parameter end, hkSimdRealParameter radius, _Inout_ hkcdAabbTreeQueries::RaycastCollector* collector) const;

        /// AABB check on the tree. The collector's callback is triggered for each leaf that overlaps with the AABB.
    void queryAabb( const hkAabb& aabb, _Inout_ hkcdAabbTreeQueries::AabbCollector* collector) const;

        /// Special-case AABB query where only the leaf IDs are saved.
        /// This is about 10% than the collector-based version (depending on platform).
    void queryAabb( const hkAabb& aabb, hkArray<hkUint32>::Temp& hits ) const;

        /// Find the closest leaf in the tree. The collector's callback is triggered for each leaf that is closer to the current smallest distance, starting at maxDistance.
    hkUint32 getClosestPoint( hkVector4Parameter point, hkSimdRealParameter maxDistance, _Inout_ hkcdAabbTreeQueries::ClosestPointCollector* collector, hkVector4& closestPointOut ) const;

        /// Finds all pairs of overlapping leaves.
    void getAllPairs(_Inout_ hkcdAabbTreeQueries::AllPairsCollector* collector ) const;

        /// Finds all leaves in this tree that overlap with leaves in the other tree.
    void getAllPairs(_In_ const hkcdStaticAabbTree* otherTree, _Inout_ hkcdAabbTreeQueries::AllPairsCollector* collector ) const;

        /// Returns the size (in bytes) of the tree.
    int getMemoryFootPrint() const;

        /// Returns the number of leaves in the tree.
    int getNumLeaves() const;

        /// Accessor for the internal tree.
    _Ret_maybenull_ const void* getTreePtr() const;

        /// Accessor for the internal tree.
    _Ret_maybenull_ void* getTreePtr();

protected:
    hkRefPtr<Impl> m_treePtr;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
