// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE void hkcdWeldingUtil::_applyModifiedNormal(
    hkVector4Parameter newNormalAndDistance, bool offsetDistance, hkSimdRealParameter radiusA, hkSimdRealParameter radiusB, hkSimdRealParameter minimumDistance,
    _Inout_ hkcdManifold4* HK_RESTRICT manifoldBInOut )
{
    if ( !manifoldBInOut->m_normal.equal( newNormalAndDistance ).allAreSet( hkVector4fComparison::Mask::MASK_XYZ ) )
    {
        // Point on Aw
        hkVector4* HK_RESTRICT pOnBs = manifoldBInOut->m_positions;
        HK_ASSERT_NO_MSG( 0xf0345465, newNormalAndDistance.isNormalized<3>() && newNormalAndDistance.isOk<4>() );
        hkVector4 planeB = manifoldBInOut->m_normal;

        hkSimdReal product = manifoldBInOut->m_normal.dot<3>( newNormalAndDistance );

        // Ensure distance is positive
        product.setAbs( product );

        hkSimdReal distanceCorrection;
        hkSimdReal radiusSum = radiusA + radiusB;
        if ( offsetDistance )
        {
            // Offset distances so that the closest points will be separated by the distance in newNormalAndDistance.w.
            hkSimdReal projectedMinimumDistance = (hkSimdReal::fromFloat( manifoldBInOut->m_minimumDistance ) + radiusSum) * product - radiusSum;
            hkSimdReal desiredMinimumDistance = newNormalAndDistance.getW();
            distanceCorrection = projectedMinimumDistance - desiredMinimumDistance;
        }
        else
        {
            distanceCorrection = hkSimdReal_0;
        }

        hkVector4 minDist4; minDist4.setConstant<HK_QUADREAL_MAX>();
        int numPoints = hkMath::min2(manifoldBInOut->m_numPoints, hkcdManifold4::MAX_NUM_CONTACT_POINTS);
        for ( int i = 0; i < numPoints; i += 4 )
        {
            // Get the current distance of each contact, ignoring the radius of shape A
            hkVector4 distances; distances.load<4>( &manifoldBInOut->m_distances[i] );
            hkVector4 oldRadiusCorrectedDistances; oldRadiusCorrectedDistances.setAdd( distances, radiusA );

            // New distance, ignoring the radius of shape A
            hkVector4 newRadiusCorrectedDistances;
            newRadiusCorrectedDistances.setAdd( distances, radiusSum );
            newRadiusCorrectedDistances.mul( product );
            newRadiusCorrectedDistances.setSub( newRadiusCorrectedDistances, distanceCorrection + radiusB );

            // Contacts on A, ignoring convex radius
            pOnBs[i].addMul( manifoldBInOut->m_normal, oldRadiusCorrectedDistances.getComponent<0>() );
            pOnBs[i + 1].addMul( manifoldBInOut->m_normal, oldRadiusCorrectedDistances.getComponent<1>() );
            pOnBs[i + 2].addMul( manifoldBInOut->m_normal, oldRadiusCorrectedDistances.getComponent<2>() );
            pOnBs[i + 3].addMul( manifoldBInOut->m_normal, oldRadiusCorrectedDistances.getComponent<3>() );

            // Contacts on B, including convex radius
            pOnBs[i].subMul( newNormalAndDistance, newRadiusCorrectedDistances.getComponent<0>() );
            pOnBs[i + 1].subMul( newNormalAndDistance, newRadiusCorrectedDistances.getComponent<1>() );
            pOnBs[i + 2].subMul( newNormalAndDistance, newRadiusCorrectedDistances.getComponent<2>() );
            pOnBs[i + 3].subMul( newNormalAndDistance, newRadiusCorrectedDistances.getComponent<3>() );

            // New distances, including convex radius
            hkVector4 newDistances; newDistances.setSub( newRadiusCorrectedDistances, radiusA );
            hkVector4 minimumDistance4; minimumDistance4.setAll( minimumDistance );
            newDistances.setMax( newDistances, minimumDistance4 );

            minDist4.setMin( minDist4, newDistances );
            newDistances.store<4>( &manifoldBInOut->m_distances[i] );
        }

        minDist4.horizontalMin<4>().store<1>( &manifoldBInOut->m_minimumDistance );
        manifoldBInOut->m_normal = newNormalAndDistance;
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
