// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Geometry/Internal/Algorithms/Gsk/hkcdGskData.h>
#include <Geometry/Collide/Types/hkcdManifold4.h>

namespace hkcdGsk { struct Cache; }

class hkcdVertex;
struct hknpWeldingConfig;

/// Utility to help with welding
namespace hkcdWeldingUtil
{
    struct MotionWeldConfig
    {
        // parameters valid for convex vs composite
        hkTransform m_transformA;
        const void* m_shapeA;

        hkVector4 m_velocityDirection;      // the normalized direction of the relative linear velocity in world space
        hkVector4 m_velocityDirectionB;     // the normalized direction of the relative linear velocity in B-space
        hkSimdReal m_relLinearVelocity;     // the length of m_velocityDirection before it got normalized

        hkSimdReal m_maxAllowedTotalCastDistance;
        hkSimdReal m_objectRadiusA;         // the total radius of object A (not the convex radius) measured in velocity direction
        hkSimdReal m_gskDistance;           // assuming radius 0.0f
        hkSimdReal m_convexRadius;          // convex radius of the shape pair
        hkSimdReal m_extraConvexRadius;     // convex radius minus allowed penetration, the smaller the better the algorithm works (so try 0.0f if possible)
        hkSimdReal m_allowedApproachingVelocity;
        hkVector4 m_velocityMulDt;      // the movement of objectA relative to object B
        const hknpWeldingConfig* m_weldingConfig;

        // parameters needed to be set for each child shape of the composite shape

        hkTransform m_bTa;                  // relative transform between a and b

        const void* m_shapeB;
        hkSimdReal m_allowedPenetration;
    };

    typedef hkcdGsk::GetClosestPointStatus (*getClosestPointFunc)(
        const void* shapeA,
        const void* shapeB,
        const hkcdGsk::GetClosestPointInput& input, _Inout_ hkcdGsk::Cache* HK_RESTRICT cache,
        hkcdGsk::GetClosestPointOutput& output );

    typedef void ( *getSupportingVerticesFunc )(
        const void* shapeA, hkVector4Parameter directionA,
        const void* shapeB, const hkTransform* bTa,
        hkcdGsk::GetSupportingVertexOut* HK_RESTRICT output);

    /// Perform a motion weld on a single convex versus convex
    /// W component of weldedNormalInOut is set to the distance between the shapes along weldedNormalInOut at their initial transforms
    HK_EXPORT_COMMON hkResult HK_CALL motionWeldCvxVsCvx(
        getClosestPointFunc func, getSupportingVerticesFunc supportFunc, const MotionWeldConfig& config, const hkcdGsk::Cache& gskCacheBlueprint, _Inout_ hkVector4* weldedNormalInOut);

    /// Modify the normal on a manifold. This will try to guess the new distances
    HK_EXPORT_COMMON void applyModifiedNormal(
        hkVector4Parameter newNormalAndDistance, bool offsetDistance, hkSimdRealParameter radiusA, hkSimdRealParameter radiusB,
        _Inout_ hkcdManifold4* HK_RESTRICT manifoldBInOut );

    /// inline version of applyModifiedNormal(), include hkcdWeldingUtil.inl if you want to use this.
    /// If offsetDistance is true, the contact points on B will be moved along the normal so that the
    /// distance of the closest points is equal to the W component of newNormalAndDistance
    HK_INLINE void _applyModifiedNormal(
        hkVector4Parameter newNormalAndDistance, bool offsetDistance, hkSimdRealParameter radiusA, hkSimdRealParameter radiusB, hkSimdRealParameter minimumDistance,
        _Inout_ hkcdManifold4* HK_RESTRICT manifoldBInOut );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
