// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0


///
/// Stack policies from queries.
///
struct HK_EXPORT_COMMON hkcdTreeQueriesStacks
{
    /// Fixed CPU stack.
    template <int SIZE, typename TYPE>
    struct FixedCpu
    {
        typedef TYPE    ItemType;

        HK_INLINE   FixedCpu(int reserve=0) : m_count(0) { HK_ASSERT(0xF4359059, reserve <= SIZE, "Cannot reserve the requested amount of stack"); }

        HK_INLINE TYPE&     push() { HK_ASSERT(0x3EE6302F, m_count<SIZE, "Stack overflow"); return m_stack[m_count++]; }
        HK_INLINE const TYPE&   pop() { HK_ASSERT(0x3EE6303F, m_count, "Stack underflow"); return m_stack[--m_count]; }
        HK_INLINE hkBool32  hasSpaceFor(int numItems) const { return m_count+numItems < SIZE; }
        HK_INLINE int           getSize() const { return m_count; }
        HK_INLINE hkBool32  isNotEmpty() const { return (hkBool32)m_count; }

    private:
        TYPE            m_stack[SIZE];
        _Field_range_(0, SIZE) int m_count;
    };

    /// Fixed software stack
    template <int SIZE, typename TYPE>
    struct FixedSoft
    {
        typedef TYPE    ItemType;

        HK_INLINE   FixedSoft(int reserve=0) : m_stack(hkAllocateStack<TYPE>(reserve > SIZE ? reserve : SIZE,"hkcdTreeQueries::Stack")),m_count(0) {}
        HK_INLINE ~FixedSoft() { hkDeallocateStack(m_stack.val(),SIZE); }

        HK_INLINE TYPE&     push() { HK_ASSERT(0x3EE6302F, m_count<SIZE, "Stack overflow"); return m_stack[m_count++]; }
        HK_INLINE const TYPE&   pop() { HK_ASSERT(0x3EE6303F, m_count, "Stack underflow"); return m_stack[--m_count]; }
        HK_INLINE hkBool32  hasSpaceFor(int numItems) const { return m_count+numItems < SIZE; }
        HK_INLINE int           getSize() const { return m_count; }
        HK_INLINE hkBool32  isNotEmpty() const { return (hkBool32)m_count; }

    private:
        TYPE*   m_stack;
        _Field_range_(0, SIZE) int m_count;
    };

    /// Dynamic stack with initial size.
    template <int SIZE, typename TYPE>
    struct Dynamic
    {
        typedef TYPE    ItemType;

        HK_INLINE   Dynamic(int reserve=0) : m_stack(reserve > SIZE ? reserve : SIZE) {}
        HK_INLINE   ~Dynamic() {}

        HK_INLINE TYPE&     push() { return m_stack.expandOne(); }
        HK_INLINE const TYPE&   pop() { HK_ASSERT(0x3EE6303F, m_stack.getSize(), "Stack underflow"); const TYPE& v=m_stack[m_stack.getSize()-1]; m_stack.popBack(); return v; }
        HK_INLINE hkBool32  hasSpaceFor(int numItems) const { return 1; }
        HK_INLINE int           getSize() const { return m_stack.getSize(); }
        HK_INLINE hkBool32  isNotEmpty() const { return (hkBool32)m_stack.getSize(); }

    private:
        hkLocalArray<TYPE>  m_stack;

    };
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
