// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0


template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename STACK_TYPE, typename QUERY>
HK_NEVER_INLINE void hkcdTreeQueries<STACK,SIZE,FLAGS>::unary(const TREE& tree, STACK_TYPE& stackInstance, QUERY& query)
{
    static const bool useCache = TREE::USE_SOFTWARE_CACHE ? true : false;
    if ( !tree.isEmpty() )
    {
        HK_COMPILE_TIME_ASSERT(sizeof(typename TREE::Slot) == sizeof(typename STACK_TYPE::ItemType));
        STACK<SIZE,typename TREE::Slot>&    stack = (STACK<SIZE,typename TREE::Slot>&)stackInstance;
        const int                           stackBase = stack.getSize();
        const int                           numFronts = IfBeginFront<QUERY>::call(query, tree);
        typename TREE::NodeContext          context;
        for ( int frontIndex=0; frontIndex < numFronts; ++frontIndex )
        {
            IfGetFront<QUERY>::call(query, frontIndex, tree, context);
            if ( query.template processNode<TREE,typename TREE::NodeContext>(context) )
            {
                for(;;)
                {
                    if ( context->isInternal() )
                    {
                        if ( !(FLAGS & hkcdTreeQueriesFlags::ALLOW_STACKLESS) || stack.hasSpaceFor(1) )
                        {
                            typename TREE::NodeContext children[2]; tree.fetchChildren(context, children, useCache);
                            switch( IfProcessChildren<QUERY,TREE>::call(query,children) )
                            {
                            case IPC_NONE:
                                IfPushFront<QUERY>::call( query, context, false );
                                break;
                            case IPC_LEFT:
                                context = children[0];
                                IfPushFront<QUERY>::call( query, children[1], false );
                                continue;
                            case IPC_RIGHT:
                                context = children[1];
                                IfPushFront<QUERY>::call( query, children[0], false );
                                continue;
                            case IPC_BOTH:
                                {
                                    const int first = IfSelect<QUERY>::call( query, children );
                                    tree.setSlotFromContext( children[1 - first], stack.push() );
                                    context = children[first];
                                }
                                continue;
                            }
                        }
                        else
                        {
                            unaryStackless<FLAGS & hkcdTreeQueriesFlags::ALLOW_STACKLESS? true : false,TREE,QUERY>::evaluate(tree, context, query);
                        }
                    }
                    else
                    {
                        IfPushFront<QUERY>::call(query, context, true);
                        UnaryTrampoline<hkcdTreeQueries, HasGetLeafTree<TREE>::Exist? 1 : 0>::processLeaf(tree, stack, query, context);
                    }

                    if ( stack.getSize() > stackBase )
                    {
                        IfPopNode<QUERY>::call(query, context);
                        tree.setContextFromSlot(stack.pop(), context, useCache);
                    }
                    else
                    {
                        break;
                    }
                }
            }
            else
            {
                IfPushFront<QUERY>::call(query, context, false);
            }
        }
        IfEndFront<QUERY>::call(query, tree);
    }
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
HK_INLINE void hkcdTreeQueries<STACK,SIZE,FLAGS>::unary(const TREE& tree, QUERY& query)
{
    STACK<SIZE,typename TREE::Slot> stack;
    unary(tree, stack, query);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE_A, typename TREE_B, typename STACK_TYPE, typename QUERY>
HK_NEVER_INLINE void    hkcdTreeQueries<STACK,SIZE,FLAGS>::binary(bool self, const TREE_A& treeA, const TREE_B& treeB, STACK_TYPE& stackInstance, QUERY& query, _In_opt_ const typename TREE_A::NodeContext* rootContextA, _In_opt_ const typename TREE_B::NodeContext* rootContextB)
{
    static const bool useCacheA = TREE_A::USE_SOFTWARE_CACHE ? true : false;
    static const bool useCacheB = TREE_B::USE_SOFTWARE_CACHE ? true : false;

    HK_ASSERT(0xBD212D59, !self || (const void*)&treeA == (const void*)&treeB, "both trees must reference the same object");
    if ( !(treeA.isEmpty() | treeB.isEmpty()) )
    {
        STACK<SIZE,SlotPair<TREE_A,TREE_B> >& stack = (STACK<SIZE,SlotPair<TREE_A,TREE_B> >&)stackInstance;
        const int stackBase = stack.getSize();

        typename TREE_A::NodeContext contextA;
        if ( rootContextA )
        {
            contextA = *rootContextA;
        }
        else
        {
            treeA.initializeRootContext(contextA, useCacheA);
        }

        typename TREE_B::NodeContext contextB;
        if ( rootContextB )
        {
            contextB = *rootContextB;
        }
        else
        {
            treeB.initializeRootContext(contextB, useCacheB);
        }

        if ( self || query.processNodes(contextA, contextB) )
        {
            typename TREE_A::Slot slotA; treeA.setSlotFromContext(contextA, slotA);
            typename TREE_B::Slot slotB; treeB.setSlotFromContext(contextB, slotB);
            for(;;)
            {
                if(self && (void*)contextA.m_node == (void*)contextB.m_node)
                {
                    if ( contextA->isInternal() && IfProcessSelf<QUERY>::call(query,contextA))
                    {
                        typename TREE_A::NodeContext children[2]; treeA.fetchChildren(contextA, children, useCacheA);

                        typename TREE_A::Slot slots[2];
                        treeA.setSlotFromContext(children[0], slots[0]);
                        treeA.setSlotFromContext(children[1], slots[1]);

                        stack.push() = SlotPair<TREE_A,TREE_B>(slots[1], (typename TREE_B::Slot&) slots[1]);
                        if ( query.processNodes(children[0], children[1]) )
                            stack.push() = SlotPair<TREE_A, TREE_B>( slots[0], (typename TREE_B::Slot&) slots[1] );

                        slotA = slots[0];
                        slotB = (typename TREE_B::Slot&)slotA;
                        contextA = children[0];
                        contextB = (typename TREE_B::NodeContext&) children[0];
                        continue;
                    }
                }
                else
                {
                    if ( contextA->isInternal() )
                    {
                        typename TREE_A::NodeContext childrenA[2]; treeA.fetchChildren(contextA, childrenA, useCacheA);

                        typename TREE_A::Slot slotsA0; treeA.setSlotFromContext(childrenA[0], slotsA0);
                        typename TREE_A::Slot slotsA1; treeA.setSlotFromContext(childrenA[1], slotsA1);

                        if ( contextB->isInternal() )
                        {
                            if ( UseTwoWayBinary<QUERY>::Exist )
                            {
                                if ( hkVector4UtilInternal::surfaceArea(contextA.m_aabb) > hkVector4UtilInternal::surfaceArea(contextB.m_aabb) )
                                    goto split_A;
                                else
                                    goto split_B;
                            }
                            else
                            {
                                typename TREE_B::NodeContext childrenB[2]; treeB.fetchChildren( contextB, childrenB, useCacheB );

                                const hkBool32 c00 = query.processNodes( childrenA[0], childrenB[0] );
                                const hkBool32 c01 = query.processNodes( childrenA[0], childrenB[1] );
                                const hkBool32 c10 = query.processNodes( childrenA[1], childrenB[0] );
                                const hkBool32 c11 = query.processNodes( childrenA[1], childrenB[1] );

                                typename TREE_B::Slot slotsB0; treeB.setSlotFromContext( childrenB[0], slotsB0 );
                                typename TREE_B::Slot slotsB1; treeB.setSlotFromContext( childrenB[1], slotsB1 );

                                if( c11 ) stack.push() = SlotPair<TREE_A, TREE_B>( slotsA1, slotsB1 );
                                if( c10 ) stack.push() = SlotPair<TREE_A, TREE_B>( slotsA1, slotsB0 );
                                if( c01 ) stack.push() = SlotPair<TREE_A, TREE_B>( slotsA0, slotsB1 );
                                if( c00 ) stack.push() = SlotPair<TREE_A, TREE_B>( slotsA0, slotsB0 );
                            }
                        }
                        else
                        {
                            split_A: {}

                            const hkBool32 c0 = query.processNodes( childrenA[0], contextB );
                            const hkBool32 c1 = query.processNodes( childrenA[1], contextB );

                            if( c1 ) stack.push() = SlotPair<TREE_A, TREE_B>( slotsA1, slotB );
                            if( c0 ) stack.push() = SlotPair<TREE_A, TREE_B>( slotsA0, slotB );
                        }
                    }
                    else
                    {
                        if ( contextB->isInternal() )
                        {
                            split_B: {}

                            typename TREE_B::NodeContext childrenB[2]; treeB.fetchChildren( contextB, childrenB, useCacheB );

                            const hkBool32 c0 = query.processNodes( contextA, childrenB[0] );
                            const hkBool32 c1 = query.processNodes( contextA, childrenB[1] );

                            typename TREE_B::Slot slotsB0; treeB.setSlotFromContext( childrenB[0], slotsB0 );
                            typename TREE_B::Slot slotsB1; treeB.setSlotFromContext( childrenB[1], slotsB1 );

                            if( c1 ) stack.push() = SlotPair<TREE_A, TREE_B>( slotA, slotsB1 );
                            if( c0 ) stack.push() = SlotPair<TREE_A, TREE_B>( slotA, slotsB0 );
                        }
                        else
                        {
                            BinaryTrampoline<hkcdTreeQueries, HasGetLeafTree<TREE_A>::Exist? 1 : 0, HasGetLeafTree<TREE_B>::Exist? 1 : 0>::processLeaves(self, treeA, treeB, stack, query, contextA, contextB);
                        }
                    }
                }

                if ( stack.getSize() > stackBase )
                {
                    const SlotPair<TREE_A,TREE_B>& nextPair = stack.pop();
                    slotA = nextPair.m_nodeA;
                    slotB = nextPair.m_nodeB;
                    treeA.setContextFromSlot( slotA, contextA, useCacheA );
                    treeB.setContextFromSlot( slotB, contextB, useCacheB );
                }
                else
                {
                    break;
                }
            }
        }
    }
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE_A, typename TREE_B, typename QUERY>
HK_INLINE void  hkcdTreeQueries<STACK,SIZE,FLAGS>::binary(bool self, const TREE_A& treeA, const TREE_B& treeB, QUERY& query, _In_opt_ const typename TREE_A::NodeContext* rootContextA, _In_opt_ const typename TREE_B::NodeContext* rootContextB)
{
    STACK<SIZE,SlotPair<TREE_A,TREE_B> >    stack;
    binary(self, treeA, treeB, stack, query, rootContextA, rootContextB);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
HK_INLINE void hkcdTreeQueries<STACK,SIZE,FLAGS>::aabbOverlapsWithEarlyExit(const TREE& tree, const hkAabb& aabb, QUERY& query)
{
    AabbOverlapsWithEarlyExitWrapper<QUERY> masterQuery(query);
    masterQuery.m_aabb = aabb;
    unary(tree, masterQuery);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
HK_INLINE void hkcdTreeQueries<STACK,SIZE,FLAGS>::aabbOverlapsNoEarlyExit(const TREE& tree, const hkAabb& aabb, QUERY& query)
{
    AabbOverlapsNoEarlyExitWrapper<QUERY> masterQuery(query);
    masterQuery.m_aabb = aabb;
    unary(tree, masterQuery);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline void     hkcdTreeQueries<STACK,SIZE,FLAGS>::aabbOverlapsNearMiss(const TREE& tree, const hkAabb& aabb, QUERY& query, hkAabb& nearMissAabb)
{
    AabbOverlapsNearMissAabbWrapper<QUERY> masterQuery(query);
    masterQuery.m_aabb = aabb;
    masterQuery.m_nearMissAabb = nearMissAabb;

    unary(tree, masterQuery);
    nearMissAabb = masterQuery.m_nearMissAabb;
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline void     hkcdTreeQueries<STACK,SIZE,FLAGS>::kineticAabbOverlaps(const TREE& tree, const hkAabb& oldAabb, const hkAabb& newAabb, QUERY& query)
{
    if(oldAabb.overlaps(newAabb))
    {   // Coherent motion.
        CoherentKineticAabbOverlapsWrapper<QUERY> masterQuery(query);
        masterQuery.m_aabbs[0] = oldAabb;
        masterQuery.m_aabbs[1] = newAabb;
        masterQuery.m_compound.m_min.setMin(oldAabb.m_min, newAabb.m_min);
        masterQuery.m_compound.m_max.setMax(oldAabb.m_max, newAabb.m_max);
        unary(tree, masterQuery);
    }
    else
    {   // General motion.
        KineticAabbOverlapsWrapper<QUERY> masterQuery(query);
        masterQuery.m_aabbs[0] = oldAabb;
        masterQuery.m_aabbs[1] = newAabb;
        unary(tree, masterQuery);
    }
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline void         hkcdTreeQueries<STACK,SIZE,FLAGS>::convexOverlaps(const TREE& tree, const hkVector4* planes, int numPlanes, QUERY& query)
{
    ConvexOverlapsWrapper<QUERY> masterQuery(query);
    masterQuery.m_tree      =   &tree;
    masterQuery.m_planes    =   planes;
    masterQuery.m_numPlanes =   numPlanes;
    unary(tree, masterQuery);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline hkBool32 hkcdTreeQueries<STACK,SIZE,FLAGS>::visible(const TREE& tree, const hkcdRay& ray, QUERY& query)
{
    VisibilityWrapper<QUERY>    masterQuery(query);
    masterQuery.m_ray = ray;
    unary(tree, masterQuery);
    return masterQuery.m_visible;
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline void hkcdTreeQueries<STACK,SIZE,FLAGS>::rayOverlaps(const TREE& tree, const hkcdRay& ray, QUERY& query)
{
    RayOverlapsWrapper<QUERY>   masterQuery(query);
    masterQuery.m_ray = ray;
    masterQuery.m_fraction = ray.getFraction();
    unary(tree, masterQuery);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline hkSimdReal hkcdTreeQueries<STACK,SIZE,FLAGS>::rayCast(const TREE& tree, const hkcdRay& ray, QUERY& query)
{
    RayCastWrapper<QUERY> masterQuery(query);
    masterQuery.m_ray   =   ray;
    unary(tree, masterQuery);
    return masterQuery.m_ray.getFraction();
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline hkSimdReal   hkcdTreeQueries<STACK,SIZE,FLAGS>::rayCast(const TREE& tree, const hkVector4& from, const hkVector4& to, QUERY& query, hkSimdRealParameter fraction)
{
    hkcdRay ray; ray.setEndPoints(from, to, fraction);
    return rayCast(tree, ray, query);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline void hkcdTreeQueries<STACK,SIZE,FLAGS>::rayCastExternal(const TREE& tree, const hkcdRay& ray, QUERY& query)
{
    RayCastWrapperExternal<QUERY> masterQuery(query);
    masterQuery.m_ray       =   ray;
    unary(tree, masterQuery);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline void     hkcdTreeQueries<STACK,SIZE,FLAGS>::rayCastBatch(const TREE& tree, _In_reads_(numRays) const hkcdRay* rays, int numRays, QUERY& query)
{
    RayCastBatchWrapper<QUERY>  masterQuery(query);
    for(int i=0; i < numRays;)
    {
        const int rayPerBatch = hkMath::min2(4, numRays-i);
        masterQuery.initialize(rays + i, rayPerBatch, i);
        unary(tree, masterQuery);
        i   +=  rayPerBatch;
    }
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline void     hkcdTreeQueries<STACK,SIZE,FLAGS>::rayCastFan(const TREE& tree, const hkVector4& from, _In_reads_(numRays) const hkVector4* to, int numRays, QUERY& query)
{
    hkcdRay*    rays = hkAllocateStack<hkcdRay>(numRays);
    for(int i=0; i<numRays; ++i)
    {
        rays[i].setEndPoints(from, to[i]);
    }
    rayCastBatch(tree, rays, numRays, query);
    hkDeallocateStack(rays, numRays);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline hkSimdReal hkcdTreeQueries<STACK,SIZE,FLAGS>::sphereCast(const TREE& tree, const hkcdRay& ray, const hkSimdReal& radius, QUERY& query)
{
    SphereCastWrapper<QUERY> masterQuery(query);
    masterQuery.m_ray       =   ray;
    masterQuery.m_radius    =   radius;
    unary(tree, masterQuery);
    return masterQuery.m_ray.getFraction();
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline hkSimdReal   hkcdTreeQueries<STACK,SIZE,FLAGS>::aabbCast(const TREE& tree, const hkAabb& from, const hkVector4& to, QUERY& query, hkReal maxFraction)
{
    AabbCastWrapper<QUERY>  masterQuery(query);
    hkSimdReal              frac; frac.setFromFloat(maxFraction);
    hkVector4               halfLengths; halfLengths.setSub(from.m_max, from.m_min); halfLengths.mul(hkSimdReal::getConstant(HK_QUADREAL_INV_2));
    hkVector4               center; from.getCenter(center);
    hkVector4               direction; direction.setSub(to, center);
    masterQuery.m_ray.setOriginDirection(center, direction, frac);
    masterQuery.m_halfExtent = halfLengths;
    unary(tree, masterQuery);
    return masterQuery.m_ray.getFraction();
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline void         hkcdTreeQueries<STACK,SIZE,FLAGS>::aabbCastExternal(const TREE& tree, const hkcdRay& ray, hkVector4Parameter halfExtents, QUERY& query)
{
    AabbCastWrapperExternal<QUERY>  masterQuery(query);
    masterQuery.m_ray           =   ray;
    masterQuery.m_halfExtent    =   halfExtents;
    unary(tree, masterQuery);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline hkSimdReal   hkcdTreeQueries<STACK,SIZE,FLAGS>::closest(const TREE& tree, const hkVector4& point, QUERY& query, const hkSimdReal& initialDistanceSquared)
{
    ClosestFromPointWrapper<QUERY> masterQuery(query);
    masterQuery.m_point             =   point;
    masterQuery.m_distanceSquared   =   initialDistanceSquared;
    masterQuery.m_selectResult      =   0;
    unary(tree, masterQuery);
    return masterQuery.m_distanceSquared;
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline hkSimdReal   hkcdTreeQueries<STACK,SIZE,FLAGS>::closest(const TREE& tree, const hkAabb& aabb, QUERY& query, const hkSimdReal& initialDistanceSquared)
{
    ClosestFromAabbWrapper<QUERY> masterQuery(query);
    aabb.getCenter(masterQuery.m_center);
    aabb.getHalfExtents(masterQuery.m_extents);
    masterQuery.m_aabb              =   aabb;
    masterQuery.m_distanceSquared   =   initialDistanceSquared;
    masterQuery.m_selectResult      =   0;
    unary(tree, masterQuery);
    return masterQuery.m_distanceSquared;
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename QUERY>
inline void     hkcdTreeQueries<STACK,SIZE,FLAGS>::allPairs(const TREE& tree, QUERY& query)
{
    AllPairsWrapper<QUERY>  masterQuery(query);
    binary(true,tree,tree,masterQuery);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE_A, typename TREE_B, typename QUERY>
inline void     hkcdTreeQueries<STACK,SIZE,FLAGS>::allPairs(const TREE_A& treeA, const TREE_B& treeB, QUERY& query)
{
    AllPairsWrapper<QUERY>  masterQuery(query);
    binary(false,treeA,treeB,masterQuery);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE_A, typename TREE_B, typename QUERY>
inline void     hkcdTreeQueries<STACK,SIZE,FLAGS>::allPairs(const TREE_A& treeA, const TREE_B& treeB, const hkTransform& AtoB, QUERY& query, hkReal marginA, hkReal marginB)
{
    AllPairsWithTransformWrapper<QUERY> masterQuery(query);
    masterQuery.m_AtoB  =   AtoB;
    masterQuery.m_BtoA.setInverse(AtoB);
    masterQuery.m_marginA.setAll(marginA);
    masterQuery.m_marginB.setAll(marginB);
    binary(false,treeA,treeB,masterQuery);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE, typename PAIR>
inline int      hkcdTreeQueries<STACK,SIZE,FLAGS>::allLeavesPairs(const TREE& tree, hkArray<PAIR>& pairs)
{
    AllLeavesPairsWrapper<PAIR> masterQuery(pairs);
    allPairs(tree, masterQuery);
    return pairs.getSize();
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE_A, typename TREE_B, typename PAIR>
inline int      hkcdTreeQueries<STACK,SIZE,FLAGS>::allLeavesPairs(const TREE_A& treeA, const TREE_B& treeB, hkArray<PAIR>& pairs)
{
    AllLeavesPairsWrapper<PAIR> masterQuery(pairs);
    allPairs(treeA, treeB, masterQuery);
    return pairs.getSize();
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE>
inline hkBool       hkcdTreeQueries<STACK,SIZE,FLAGS>::aabbExist(const TREE& tree, const hkAabb& aabb, typename TREE::Index& leafOut)
{
    AabbExistWrapper query;
    query.m_aabb    =   aabb;
    query.m_leaf    =   (int)TREE::INVALID_INDEX;

    aabbOverlapsWithEarlyExit(tree, aabb, query);

    leafOut         =   (typename TREE::Index) query.m_leaf;
    return leafOut != (int)TREE::INVALID_INDEX;
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE>
inline hkBool       hkcdTreeQueries<STACK,SIZE,FLAGS>::pointExist(const TREE& tree, const hkVector4& point, typename TREE::Index& leafOut)
{
    hkAabb  aabb;
    aabb.m_min = point;
    aabb.m_max = point;
    return aabbExist(tree, aabb, leafOut);
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE>
inline hkBool       hkcdTreeQueries<STACK,SIZE,FLAGS>::locatePoint(const TREE& tree, const hkVector4& point, typename TREE::Index& leafOut)
{
    LocatePointWrapper query;
    query.m_point   =   point;
    query.m_leaf    =   (int)TREE::INVALID_INDEX;

    hkAabb              aabb;
    aabb.m_min      =   point;
    aabb.m_max      =   point;

    aabbOverlapsWithEarlyExit(tree, aabb, query);

    leafOut         =   (typename TREE::Index) query.m_leaf;
    return leafOut != (int)TREE::INVALID_INDEX;
}

//
template <template <int SIZE, typename TYPE> class STACK, int SIZE, int FLAGS>
template <typename TREE>
inline hkBool       hkcdTreeQueries<STACK,SIZE,FLAGS>::overlapExist(const TREE& tree, const hkAabb& aabb, _Inout_opt_ typename TREE::Index* leafOut)
{
    OverlapExistWrapper query;
    query.m_aabb    =   aabb;
    query.m_overlap =   0;

    aabbOverlapsWithEarlyExit(tree, aabb, query);

    if(query.m_overlap)
    {
        if(leafOut) *leafOut = (typename TREE::Index) query.m_leaf;
        return true;
    }
    return false;
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
