// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

// this: #include <Geometry/Internal/Algorithms/SignedDistanceField/Triangulate/hkcdSignedDistanceFieldTriangulator.h>

#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>

struct HK_EXPORT_COMMON hkcdSignedDistanceFieldTriangulator
{

    struct HK_EXPORT_COMMON Function
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES, Function );

        virtual         ~Function() {}
        virtual hkReal  evaluate(const hkVector4& position, _In_opt_ hkVector4* normal = HK_NULL) const=0;
    };

    struct HK_EXPORT_COMMON Config
    {
        Config() : m_minDepth( 3 ), m_maxDepth( 7 ), m_sharpnessPasses( 8 ), m_fairingPasses( 4 ), m_flatAngle( 0 * HK_REAL_DEG_TO_RAD ), m_minCurvature( 10.0f * HK_REAL_DEG_TO_RAD ), m_scale( 1.0f ) {}

        int     m_minDepth;
        int     m_maxDepth;
        int     m_sharpnessPasses;
        int     m_fairingPasses;
        hkReal  m_flatAngle;
        hkReal  m_minCurvature;
        hkReal  m_scale;
    };

    static void HK_CALL triangulateSignedDistanceField(const Config& config, _In_ const Function* function, const hkAabb& domain, hkGeometry& geometry);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
