// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Math/Vector/hkFourTransposedPoints.h>
#include <Geometry/Collide/Types/hkcdRay.h>
#include <Geometry/Collide/Types/hkcdRayBundle.h>


    //// Raycast against a sphere.
    /// See \ref RayCastDocumentation for common input and output parameter descriptions.
    /// \param[in] spherePosAndRadius   Sphere position and radius (stored in the w component)
    /// \note Limit cases:
    /// -   If the ray is completely contained inside the sphere there is no intersection unless the start lies
    ///     exactly on the sphere surface.
    /// -   If the ray start lies on the sphere surface and the end is not contained in the sphere there is no intersection
    ///
    /// \sa hkcdRayBundleSphereIntersect for a version for multiple rays.
HK_INLINE   hkcdRayCastResult hkcdRayCastSphere(
    const hkcdRay& ray,
    hkVector4Parameter spherePosAndRadius,
    _Inout_ hkSimdReal* HK_RESTRICT hitFractionInOut,
    _Inout_ hkVector4* HK_RESTRICT normalOut,
    hkFlags<hkcdRayQueryFlags::Enum,hkUint32> flags);


HK_INLINE hkVector4Comparison hkcdRayBundleSphereIntersect(
    const hkcdRayBundle& rayBundle, hkSimdRealParameter sphereRadius,
    hkVector4& fractionsInOut, hkFourTransposedPoints& normalsOut );

#include <Geometry/Internal/Algorithms/RayCast/hkcdRayCastSphere.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
