// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Math/Vector/hkVector4Util.h>
#include <Common/Base/Math/Vector/hkIntVector.h>
#include <Geometry/Collide/Types/hkcdRay.h>


    /// Raycast against a convex shape, given as a collection of boundary planes.
    /// If you don't have the planeEquations, use hkGsk::rayCast instead.
    /// See \ref RayCastDocumentation for common input and output parameter descriptions.
    /// \note The planeEquations array is read in batches of 4 vectors, so a minimum of 4 plane equations must be passed in.
HK_INLINE hkcdRayCastResult HK_CALL hkcdRayCastConvex(
    const hkcdRay& ray,
    _In_reads_(numPlaneEquations) const hkVector4* HK_RESTRICT planeEquations,
    _In_range_(>=, 4) int numPlaneEquations,
    hkSimdRealParameter planeExpansion, // This shifts all planes outwards
    _Inout_ hkSimdReal* HK_RESTRICT fractionInOut,
    _Inout_ hkVector4* HK_RESTRICT normalOut,
    hkFlags<hkcdRayQueryFlags::Enum,hkUint32> flags );


#include <Geometry/Internal/Algorithms/RayCast/hkcdRayCastConvex.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
