// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Geometry/Collide/Types/hkcdRay.h>
#include <Geometry/Collide/Types/hkcdRayBundle.h>


    /// Hit type for hkcdRayCastCapsule
enum hkcdRayCastCapsuleHitType
{
    HK_CD_RAY_CAPSULE_NONE = 0,
    HK_CD_RAY_CAPSULE_CAP0,
    HK_CD_RAY_CAPSULE_CAP1,
    HK_CD_RAY_CAPSULE_BODY,
};


    /// Raycast against a capsule.
    /// See \ref RayCastDocumentation for common input and output parameter descriptions.
    /// \param[out] hitTypeOut the part of the capsule hit (the ends or cylindrical "body")
HK_INLINE hkcdRayCastResult hkcdRayCastCapsule(
    const hkcdRay& ray,
    hkVector4Parameter vertex0,
    hkVector4Parameter vertex1,
    hkSimdRealParameter radius,
    _Inout_ hkSimdReal* HK_RESTRICT fractionInOut,
    _Inout_ hkVector4* HK_RESTRICT normalOut,
    _Inout_ hkcdRayCastCapsuleHitType* HK_RESTRICT hitTypeOut,
    hkFlags<hkcdRayQueryFlags::Enum,hkUint32> flags );


    /// Bundle version or ray capsule intersection check.
HK_INLINE hkVector4Comparison hkcdRayBundleCapsuleIntersect(
    const hkcdRayBundle& rayBundle,
    hkVector4Parameter vertex0, hkVector4Parameter vertex1, hkSimdRealParameter radius,
    hkVector4& fractionsInOut, hkFourTransposedPoints& normalsOut );



    /// Bundle version of hkcdRayCastCapsule
//HK_INLINE hkVector4Comparison hkcdRayCastBundleCapsule(
//  const hkcdRayBundle& rayBundle,
//  hkVector4Parameter vertex0,
//  hkVector4Parameter vertex1,
//  hkSimdRealParameter radius,
//  hkVector4* HK_RESTRICT fractionsInOut,
//  hkFourTransposedPoints* HK_RESTRICT normalsOut );

#include <Geometry/Internal/Algorithms/RayCast/hkcdRayCastCapsule.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
