// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Geometry/Collide/Types/hkcdVertex.h>
#include <Geometry/Collide/Algorithms/Intersect/hkcdIntersectPointTriangle.h>
#include <Geometry/Internal/Algorithms/Gsk/hkcdGskData.h>

namespace hkcdGsk{ struct ShapeInterface; };
class hkContactPoint;




    ///
    /// Generic GSK.
    /// SHAPE_A and SHAPE_B must implement the following:
    ///
    /// \code void convertVertexIdsToVertices( hkUint8* ids, int numVerts, hkcdVertex* verticesOut ) const \endcode
    ///     Convert a set of vertex ids into actual supporting vertices, in particular, verticesOut[].getInt24W() must match ids[].
    ///
    /// \code void getSupportingVertex(hkVector4Parameter direction, hkcdVertex& svOut) const \endcode
    ///     Retrieve a supporting vertex into 'svOut' in the direction 'direction'.
    ///
    /// In addition, the SHAPE_INTERFACE object must implement the following:
    ///
    /// \code static void getSupportingVertices(    const hknpConvexShape* HK_RESTRICT shapeA, hkVector4Parameter directionA,
    ///                                         const hknpConvexShape* HK_RESTRICT shapeB, hkVector4Parameter directionB,
    ///                                         hkcdVertex* HK_RESTRICT vertexAOut, hkcdVertex* HK_RESTRICT vertexBOut) \endcode
    ///     Allow for optimized version of two separate call to getSupportingVertex.
    ///
class hkcdGskBase: public hkcdGsk::GskWorkData
{
    //
    //  Internal section
    //
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkcdGskBase );

    typedef void Shape;

    enum
    {
        GSK_NONE_NONE      = (0<<3) + 0,
        GSK_POINT_POINT    = (1<<3) + 1,
        GSK_POINT_EDGE     = (1<<3) + 2,
        GSK_EDGE_POINT     = (2<<3) + 1,
        GSK_POINT_TRIANGLE = (1<<3) + 3,
        GSK_TRIANGLE_POINT = (3<<3) + 1,
        GSK_EDGE_TRIANGLE  = (2<<3) + 3,
        GSK_TRIANGLE_EDGE  = (3<<3) + 2,
        GSK_POINT_TETRA    = (1<<3) + 4,
        GSK_TETRA_POINT    = (4<<3) + 1,
        GSK_EDGE_EDGE      = (2<<3) + 2
    };

    enum NextCase
    {
        NEXT_IS_POINT_TRIANGLE,
        NEXT_IS_PENETRATION,
        NEXT_IS_EDGE_EDGE
    };

    enum SupportTypes
    {
        BUILD_NEG_SUPPORT = -hkVector4ComparisonMask::MASK_X,
        BUILD_NO_SUPPORT =  0,
        BUILD_POS_SUPPORT = hkVector4ComparisonMask::MASK_X
    };

    enum SupportState
    {
        SUPPORT_CHANGED     = 0,
        DONT_CALL_GET_SUPPORTING_VERTEX_A = BUILD_POS_SUPPORT,
        DONT_CALL_GET_SUPPORTING_VERTEX_B = BUILD_NEG_SUPPORT
    };

        /// Helper class to access shape functions
    struct ShapeInterface : public hkcdGsk::ShapeInterface
    {
        static HK_INLINE hkBool32 isImplicit() { return 0; }
    };

        /// Ray-cast shape interface
    template <typename SHAPE_TYPE>
    struct RayCastShapeInterface : public ShapeInterface, public hkcdGsk::Cache
    {
        HK_DECLARE_CLASS(RayCastShapeInterface, NewOpaque );

        HK_INLINE_VIRTUAL virtual void getSupportingVertices(
            _In_ const void* shapeA, hkVector4Parameter directionA, _In_ const void* shapeB, _In_ const hkTransform* bTa,
            hkcdGsk::GetSupportingVertexOut* HK_RESTRICT output ) const HK_OVERRIDE_INLINE;

        HK_INLINE_VIRTUAL virtual void getPlanes(
            const void* shapeA, const void* shapeB,
            hkVector4 const ** planesA, int& numPlanesA,
            hkVector4 const ** planesB, int& numPlanesB) const HK_OVERRIDE_INLINE;

        HK_INLINE void getFirstVertices( const void* shapeA, const void* shapeB, hkcdVertex* firstVertexOfAinA, hkcdVertex* firstVertexOfBinB) const;
    };

        /// Print current two simplexes.
    HK_EXPORT_COMMON void print();

        /// Casts a ray [rayFrom, rayTo] towards the given shape. Returns the intersection fraction and the normal at the point of intersection
        /// if the ray intersects the shape.
    template <typename SHAPE_TYPE>
    static bool HK_CALL castRay(_In_ const SHAPE_TYPE* shape, const hkcdGsk::RayCastInput& input, hkSimdReal& fractionInOut, hkVector4& normalOut);

protected:

    // temporary data, this holds the dot products of the edge plane equations and
    // the point (if all values are negative, point is inside triangle)
    // m_checkTriangleDots to the unscaled distance of the point projected onto the triangle and the edges

protected:

    enum ReduceDimensionResult
    {
        REDUCE_DIMENSION_OK,
        REDUCE_DIMENSION_PENETRATION
    };


    template<bool checkSupport>
    HK_INLINE int _checkTriangleBoundaries( hkVector4Parameter a, _In_reads_(3) hkVector4* HK_RESTRICT triangle, _Inout_ hkVector4* HK_RESTRICT supportOut );

    HK_INLINE NextCase _processEdgeTriangle(_Inout_updates_(2) hkVector4* HK_RESTRICT vertexA, _Inout_updates_(3) hkVector4* HK_RESTRICT vertexB, hkBool32 comingFromEdgeEdge, _Inout_ hkVector4* HK_RESTRICT supportOut);

    // checks dimA + dimB <= 4 for correctness
    // and allows for repeated calls for dimA + dimB == 5
    HK_INLINE ReduceDimensionResult reduceDimension(int& dimA, int& dimB, hkVector4& support, bool assumeStaticOjbects = true );


    HK_INLINE static int findClosestTriangleBackup( hkVector4Parameter a0, _In_reads_(3) const hkVector4* tetra, hkVector4Parameter oldDots, hkSimdRealParameter sign );
    HK_INLINE static int findClosestTriangle( hkVector4Parameter a0, _In_reads_(3) const hkVector4* HK_RESTRICT tetra, hkSimdRealParameter sign, bool assumeStaticOjbects);

    template<int supportType>
    HK_INLINE static int process_point_edge(_In_ const hkVector4* HK_RESTRICT vertexA, _Inout_updates_(2) hkVector4* HK_RESTRICT vertexB, _In_range_(==, 2) int dimB, _Inout_ hkVector4* HK_RESTRICT support);

    HK_EXPORT_COMMON hkcdGsk::GetClosestPointStatus handlePenetration(_In_ const ShapeInterface* shapeInterface, _In_ const Shape* shapeA, _In_ const Shape* shapeB, _In_ const hkTransform* bTa, int& dimA, int& dimB, hkcdGsk::GetClosestPointOutput& output, hkVector4* HK_RESTRICT supportOut);

    template<bool checkSupport>
    HK_NEVER_INLINE int checkTriangleBoundaries( hkVector4Parameter a, _In_reads_(3) hkVector4* HK_RESTRICT triangle, _Inout_ hkVector4* HK_RESTRICT supportOut );

    NextCase processEdgeTriangle(_Inout_updates_(3) hkVector4* HK_RESTRICT vertexA, _Inout_updates_(3) hkVector4* HK_RESTRICT vertexB, hkBool32 comingFromEdgeEdge, _Inout_ hkVector4* HK_RESTRICT supportOut );

protected:

    HK_EXPORT_COMMON static const hkVector4ComparisonMask::Mask s_dimToMaskY[4];
    HK_EXPORT_COMMON static const hkVector4ComparisonMask::Mask s_dimToMaskZ[4];

    /// returns the index of the bit set if passed in a compare mask or a index-8 of the only bit not set, works only on XYZ
    /// returns -1 for invalid input
    HK_EXPORT_COMMON static const hkInt8 s_maskToIndex[];
    HK_EXPORT_COMMON static const hkInt8 s_vertexToEdgeLut[];

    hkVector4 m_checkTriangleDots;

    int m_lastDimB; // m_dimA + m_dimB == m_lastDimA + m_lastDimB + reduced_dimension ? 1 : 0

#define HK_ON_CD_TRACK_FEATURE_CHANGE(x)
    HK_ON_CD_TRACK_FEATURE_CHANGE(int m_featureChange);

public:

    // If the closest feature has dimA+dimB > 4, then they are reduced so that dimA+dimB = 4 and m_truncated is set.
    // Continuous collision detection needs this to know that the full closest features might have changed between
    // two GSK results even though the truncated features are the same.
    bool m_truncated;

protected:

    hkVector4 m_support;
    hkVector4 m_closestPointOnEdgeA;
};


template <typename SHAPE_INTERFACE>
class hkcdGskImpl : public hkcdGskBase
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkcdGskImpl );

    public:

        /// Get the closest point between two objects, always returns the separatingNormalOut,
        /// only return pointOnBOut if distance < m_collisionTolerance.
        template <typename CACHE_TYPE>
        HK_INLINE hkcdGsk::GetClosestPointStatus getClosestPoint(
            _In_ const SHAPE_INTERFACE* shapeInterface, _In_ const Shape* shapeA, _In_ const Shape* shapeB,
            const hkcdGsk::GetClosestPointInput& input, _Inout_ CACHE_TYPE* HK_RESTRICT cache,
            hkcdGsk::GetClosestPointOutput& output );

        /// Linear cast
        HK_INLINE void linearCast(
            const SHAPE_INTERFACE* shapeInterface, const Shape* shapeA, const Shape* shapeB,
            const hkcdGsk::LinearCastInput& input,
            hkcdGsk::LinearCastOutput* output, hkcdGsk::LinearCastOutput* startCollector = HK_NULL);

        /// Linear cast
        HK_INLINE bool sphereCast(
            _In_ const SHAPE_INTERFACE* shapeInterface, _In_ const Shape* shape, _In_ const Shape* castShape,
            const hkcdGsk::LinearCastInput& input,
            hkSimdReal& fractionInOut, hkVector4& normalOut );

    protected:

        HK_INLINE hkcdGsk::GetClosestPointStatus getClosestPointImpl(
            _In_ const SHAPE_INTERFACE* shapeInterface, _In_ const Shape* shapeA, _In_ const Shape* shapeB,
            const hkcdGsk::GetClosestPointInput& input,
            int& dimAInout, int& dimBInout, hkcdGsk::GetClosestPointOutput* output );
};

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
