// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

// this: #include <Geometry/Internal/Algorithms/Gsk/hkcdGsk.h>

#include <Geometry/Collide/Types/hkcdVertex.h>  
#include <Geometry/Internal/Algorithms/Gsk/hkcdGskData.h>

template<typename FT> class hkFourTransposedPointsImpl;

/// See hkGskData.h for the input & output structures used here.
namespace hkcdGsk
{
    struct GetClosestPointOutput;

    /// Get closest point with penetration.
    /// vertsA and vertsB arrays should be padded to next multiple of 4
    /// (duplicating the last vertex).
    HK_EXPORT_COMMON GetClosestPointStatus HK_CALL getClosestPoint(
        _In_reads_(numVertsA) const hkcdVertex* vertsA, int numVertsA,
        _In_reads_(numVertsB) const hkcdVertex* vertsB, int numVertsB,
        const GetClosestPointInput& input, _Inout_ Cache* HK_RESTRICT cache, GetClosestPointOutput& output );

    /// Linear cast.
    HK_EXPORT_COMMON bool HK_CALL linearCast(
        _In_reads_(numVertsShape) const hkcdVertex* vertsShape, int numVertsShape,
        _In_reads_(numVertsCast) const hkcdVertex* vertsCast, int numVertsCast,
        const LinearCastInput& input, LinearCastOutput& output, LinearCastOutput* startPointOutput  = HK_NULL );

    /// Ray cast defined vs the convex hull of vertices
    HK_EXPORT_COMMON bool HK_CALL rayCast(
        _In_reads_(numVerts) const hkcdVertex* verts, int numVerts,
        const RayCastInput& input, RayCastOutput& output );

    /// Ray cast versus convex object defined by a set of transposed points.
    HK_EXPORT_COMMON bool HK_CALL rayCast(
        HK_ON_REAL_IS_DOUBLE( _In_reads_(numUnTransposed) const hkFourTransposedPointsImpl<double>* verts) // we cannot use hkFourTransposedPoints since its forward declared
        HK_ON_REAL_IS_FLOAT ( _In_reads_(numUnTransposed) const hkFourTransposedPointsImpl<float>* verts )
        , int numUnTransposed,
        const RayCastInput& input, RayCastOutput& output );

    /// Find a common normal that separates one object from many others assuming shapeA penetrates all shapeBs
    HK_EXPORT_COMMON int HK_CALL solveMultiPenetration(
        _In_ const ShapeInterface* si, _In_ const Shape* shapeA, const hkTransform& wTa,
        _In_reads_(numShapeBs) const Shape** shapeBs, int numShapeBs,
        _In_reads_(numTransforms) const hkTransform* aTb, int numTransforms,    // if all shapeB share one transform, set numTransforms to 0, else to numShapeBs
        _Inout_ hkcdGsk::GetClosestPointOutput* result );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
