// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// this: #include <Geometry/Collide/Types/hkcdVertex.h>

    /// A class holding a position and a 16-bit id in the .w component.
class hkcdVertex : public hkVector4
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkcdVertex );
        HK_DECLARE_POD_TYPE();

        HK_INLINE const hkcdVertex& operator=( const hkcdVertex& p ) { assign(p); return *this; }

            /// Overwrite self with an hkVector4
        HK_INLINE void assign( hkVector4Parameter p ) { m_quad = p.m_quad; }
        HK_INLINE void assign( hkVector4Parameter p, int id ) { m_quad = p.m_quad; setInt24W(id); }

            /// Extract the 16 bit id from the .w component.
        HK_ALWAYS_INLINE int getId() const { return getInt16W(); }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
