// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE
#pragma once


#include <Common/Base/hkBase.h>
#include <Common/Base/Types/hkHandle.h>
#include <Common/Base/Math/Vector/hkFourTransposedPoints.h>



/// Represents 4 line segments (rays) bundled together.
/// The start and end position are stored in transposed form
struct HK_EXPORT_COMMON hkcdRayBundle
{
    HK_INLINE hkcdRayBundle() {}
    /// Returns the direction
    HK_INLINE void getDirection(hkFourTransposedPoints& directionOut) const
    {
        directionOut.setSub(m_end, m_start);
    }

    /// The start positions of 4 rays transposed
    hkFourTransposedPoints m_start;

    /// The end positions of 4 rays transposed
    hkFourTransposedPoints m_end;

    /// A mask indicating which rays are active
    hkVector4Comparison m_activeRays;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
