// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

/// Set from direction. Does not modify the origin
HK_INLINE   void hkcdRay_setDirection( hkVector4Parameter direction, hkSimdRealParameter fraction, hkcdRay* HK_RESTRICT ray )
{
    hkVector4 directionV;
    directionV.setXYZ_W( direction, fraction );
    directionV.zeroIfTrue( directionV.equalZero() ); // Avoid negative zeros to ensure that the reciprocals of zeros are positive.

    hkVector4 invDirection; invDirection.setReciprocal<HK_ACC_RAYCAST, HK_DIV_SET_MAX>( directionV );
    ray->m_direction = directionV;
    ray->m_invDirection = invDirection;
}

//
HK_INLINE   void hkcdRay::setEndPoints( hkVector4Parameter start, hkVector4Parameter end, hkSimdRealParameter fraction )
{
    hkVector4   direction; direction.setSub( end, start );
    hkcdRay_setDirection( direction, fraction, this );
    m_origin = start;
}


//
HK_INLINE   void hkcdRay::setOriginDirection( hkVector4Parameter origin, hkVector4Parameter direction, hkSimdRealParameter fraction )
{
    hkcdRay_setDirection( direction, fraction, this );
    m_origin = origin;
}

//
//  Computes the ray end-point

HK_INLINE void hkcdRay::getEndPoint( hkVector4& vEndPoint ) const
{
    vEndPoint.setAddMul( m_origin, m_direction, getFraction() );
}

/*static*/ HK_INLINE void hkcdRayQueryFlags::isFlagSet( hkFlags<hkcdRayQueryFlags::Enum, hkUint32> flags, Enum flag, hkVector4Comparison& out )
{
    HK_ASSERT_NO_MSG( 0xf034fe54, hkUint32( flag ) < 16 );
    out.set( hkVector4ComparisonMask::Mask( ( ( 0 - ( flags.get()&flag ) ) >> 4 )  & hkVector4ComparisonMask::MASK_XYZW ) );
}

#define HK_STRINGIFY_CASE(x) case x: do { return stream << #x; }while(0)

HK_INLINE hkOstream& operator<<( hkOstream& stream, const hkcdRayCastResult result )
{
    switch ( result.m_value )
    {
        HK_STRINGIFY_CASE( hkcdRayCastResult::NO_HIT );
        HK_STRINGIFY_CASE( hkcdRayCastResult::BACK_FACE_HIT );
        HK_STRINGIFY_CASE( hkcdRayCastResult::FRONT_FACE_HIT );
        HK_STRINGIFY_CASE( hkcdRayCastResult::INSIDE_HIT );
        default:
            HK_ASSERT( 0x7aa47435, false, "Unknown or bad hkcdRayCastResult." );
            return stream << "Unknown or bad hkcdRayCastResult.";
    }
}

#undef HK_STRINGIFY_CASE

HK_INLINE void hkcdRay::setTransformedRay(const hkTransform& transform, const hkcdRay& ray)
{
    m_origin.setTransformedPos(transform, ray.m_origin);
    m_direction.setRotatedDir(transform.getRotation(), ray.m_direction);
    m_direction.setW(ray.m_direction.getW());
    m_direction.zeroIfTrue(m_direction.equalZero()); // Avoid negative zeros to ensure that the reciprocals of zeros are positive.
    m_invDirection.setReciprocal<HK_ACC_RAYCAST, HK_DIV_SET_MAX>(m_direction);
}

HK_INLINE void hkcdRay::setTransformedInverseRay(const hkTransform& transform, const hkcdRay& ray)
{
    m_origin.setTransformedInversePos(transform, ray.m_origin);
    m_direction.setRotatedInverseDir(transform.getRotation(), ray.m_direction);
    m_direction.setW(ray.m_direction.getW());
    m_direction.zeroIfTrue(m_direction.equalZero()); // Avoid negative zeros to ensure that the reciprocals of zeros are positive.
    m_invDirection.setReciprocal<HK_ACC_RAYCAST, HK_DIV_SET_MAX>(m_direction);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
