// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
HK_INLINE void      hkcdObb::setEmpty()
{
    m_transform.setIdentity();
}

//
HK_INLINE int       hkcdObb::getFlags() const
{
    return m_transform.getTranslation().getInt16W();
}

//
HK_INLINE void      hkcdObb::updateFlags()
{
    hkVector4 he; getHalfExtents( he );
    int flags = int( he.lessEqual( hkVector4::getConstant<HK_QUADREAL_EPS>() ).getMask() ) & hkVector4ComparisonMask::MASK_XYZ;
    if ( m_transform.getRotation().isApproximatelyEqual( hkMatrix3::getIdentity() ) ) flags |= FLAG_ORIENTATION_IS_IDENTITY;
    if ( m_transform.getTranslation().lengthSquared<3>() < hkSimdReal_Eps ) flags |= FLAG_POSITION_IS_ORIGIN;
    m_transform.getTranslation().setInt24W( flags );
}

//
HK_INLINE void      hkcdObb::setMulInverseMul( const hkTransform& a, const hkcdObb &b )
{
    hkVector4 he; b.getHalfExtents( he );
    m_transform._setMulInverseMul( a, b.m_transform );
    setHalfExtents( he );
    m_transform.getTranslation().setInt24W( 0 );
}

//
HK_INLINE void      hkcdObb::setMul( const hkTransform &a, const hkcdObb &b )
{
    hkVector4 he; b.getHalfExtents( he );
    m_transform.setMul( a, b.m_transform );
    setHalfExtents( he );
    m_transform.getTranslation().setInt24W( 0 );
}

//
HK_INLINE bool      hkcdObb::isEmpty() const
{
    hkVector4 he; getHalfExtents( he );
    return he.equalZero().allAreSet<hkVector4ComparisonMask::MASK_XYZ>() != 0;
}

//
HK_INLINE void  hkcdObb::getHalfExtents( hkVector4& he ) const
{
    he.set( m_transform.getColumn<0>().getW(), m_transform.getColumn<1>().getW(), m_transform.getColumn<2>().getW(), hkSimdReal_0 );
}

//
HK_INLINE void  hkcdObb::setHalfExtents( const hkVector4& he )
{
    m_transform.getColumn(0).setW( he.getComponent<0>() );
    m_transform.getColumn(1).setW( he.getComponent<1>() );
    m_transform.getColumn(2).setW( he.getComponent<2>() );
}

//
HK_INLINE void  hkcdObb::expandBy( hkReal exp )
{
    m_transform.getColumn(0)(3) += exp;
    m_transform.getColumn(1)(3) += exp;
    m_transform.getColumn(2)(3) += exp;
}

//
HK_INLINE void  hkcdObb::getLocalAabb( hkAabb& aabbOut ) const
{
    hkVector4 he; getHalfExtents( he );
    aabbOut.setFromCenterRadius( hkVector4::getZero(), he );
}

//
HK_INLINE hkReal    hkcdObb::getSurfaceArea() const
{
    hkVector4 e; getHalfExtents( e ); e.mul( hkSimdReal_2 );
    return 2 * ( e( 0 )*e( 1 ) + e( 1 )*e( 2 ) + e( 2 )*e( 0 ) );
}

//
HK_INLINE hkReal    hkcdObb::getVolume() const
{
    hkVector4 e; getHalfExtents( e ); e.mul( hkSimdReal_2 );
    return e( 0 )*e( 1 )*e( 2 );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
