// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

//
// Query support.
//

/// Initialize root context.
template <typename STORAGE>
HK_INLINE void      hkcdStaticTree::Tree<STORAGE>::initializeRootContext(NodeContext& context, bool useCache) const
{
    context.m_aabb  =   m_domain;
    context.m_node  =   STORAGE::getNode(0, useCache);
    context.m_index =   0;
}

/// Fetch the children of a given context.
template <typename STORAGE>
HK_INLINE void      hkcdStaticTree::Tree<STORAGE>::fetchChildren(const NodeContext& context, NodeContext* children, bool useCache) const
{
    children[0].m_index =   context.m_index+1;
    children[1].m_index =   context.m_index+context.m_node->getDelta();
    children[0].m_node  =   STORAGE::getNode(children[0].m_index, useCache);
    children[1].m_node  =   STORAGE::getNode(children[1].m_index, useCache);
    Node::unpack(context.m_aabb, *children[0].m_node, *children[1].m_node, children[0].m_aabb, children[1].m_aabb);
}

/// Set context from slot.
template <typename STORAGE>
HK_INLINE void      hkcdStaticTree::Tree<STORAGE>::setContextFromSlot(const Slot& slot, NodeContext& context, bool useCache) const
{
    context.m_index =   slot.m_index;
    context.m_node  =   STORAGE::getNode(slot.m_index, useCache);
    context.m_aabb  =   slot.m_aabb;
}

/// Set context from a node index.
template <typename STORAGE>
HK_INLINE void      hkcdStaticTree::Tree<STORAGE>::setContextFromNode(Index node, NodeContext& context, bool useCache) const
{
    context.m_index =   node;
    context.m_node  =   STORAGE::getNode(node, useCache);
    context.m_aabb.setEmpty();
}

/// Set slot from context.
template <typename STORAGE>
HK_INLINE void      hkcdStaticTree::Tree<STORAGE>::setSlotFromContext(const NodeContext& context, Slot& slot) const
{
    slot = (const Slot&)context;
}

//
template <typename STORAGE>
inline void                 hkcdStaticTree::Tree<STORAGE>::getNodeAabb(Index node, hkAabb& aabb) const
{
    Index   currentNode = getRoot();
    hkAabb  currentAabb; getDomain(currentAabb);
    while(currentNode != node)
    {
        const Node* p = STORAGE::getNode(currentNode);
        HK_ASSERT(0x27412AC3, p->isInternal(), "The requested node do not exist");
        const Index childrenIndex[] = { currentNode + 1, currentNode + p->getDelta() };
        const Index childIndex = childrenIndex[node >= childrenIndex[1] ? 1 : 0];
        hkAabb      childAabb; Node::unpack(currentAabb, *STORAGE::getNode(childIndex), childAabb);
        currentAabb = childAabb;
        currentNode = childIndex;
    }
    aabb = currentAabb;
}

//
template <typename STORAGE>
inline typename hkcdStaticTree::Tree<STORAGE>::Index    hkcdStaticTree::Tree<STORAGE>::findLeafByValue(int value) const
{
    for(int i=0,n=STORAGE::getNumNodes(); i<n; ++i)
    {
        const Node* p = STORAGE::getNode(i);
        if(!p->isInternal())
        {
            if(value == p->getData()) return (Index)i;
        }
    }
    return (Index)INVALID_INDEX;
}
//
// Filtering.
//

//
template <int BITS_PER_NODE>
HK_INLINE int       hkcdStaticTree::Filtering<BITS_PER_NODE>::get(const hkUint32* clusters, int node)
{
    const int   c_index = (int) (node * BITS_PER_NODE) / BITS_PER_CLUSTER;
    const int   b_index = (int) (node * BITS_PER_NODE) % BITS_PER_CLUSTER;
    return int((clusters[c_index] >> b_index) & MASK);
}

//
template <int BITS_PER_NODE>
HK_INLINE void  hkcdStaticTree::Filtering<BITS_PER_NODE>::set(hkUint32* clusters, int node, int value)
{
    const int   c_index = (int) (node * BITS_PER_NODE) / BITS_PER_CLUSTER;
    const int   b_index = (int) (node * BITS_PER_NODE) % BITS_PER_CLUSTER;
    clusters[c_index] &= ~(hkUint32(MASK) << b_index);
    clusters[c_index] |= hkUint32(value) << b_index;
}

//
template <int BITS_PER_NODE>
template <typename TREE>
HK_NEVER_INLINE bool    hkcdStaticTree::Filtering<BITS_PER_NODE>::computeFilter(const TREE& tree, hkUint32* clusters)
{
    if(!tree.isEmpty())
    {
        typename TREE::NodeContext root; tree.initializeRootContext(root,false);
        return computeFilter(tree, root, clusters);
    }
    return false;
}

//
template <int BITS_PER_NODE>
template <typename TREE>
HK_NEVER_INLINE bool    hkcdStaticTree::Filtering<BITS_PER_NODE>::computeFilter(const TREE& tree, const typename TREE::NodeContext& node, hkUint32* clusters)
{
    if(node->isInternal())
    {
        typename TREE::NodeContext  children[2]; tree.fetchChildren(node, children, false);
        const bool                  valid = computeFilter(tree, children[0], clusters) | computeFilter(tree, children[1], clusters);
        set(clusters, node.m_index, valid ? MASK : 0);
        return valid;
    }
    else
    {
        return get(clusters, node.m_index) != 0;
    }
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
