// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

//
// Primitive.
//

// Patterns:
// 0xde 0xad 0xde 0xad : INVALID
// a b CUSTOM b : CUSTOM
// a a EXTERNAL a : EXTERNAL
// a b c c : TRIANGLE
// a b c d : QUAD,   b > d -> flat quad
HK_INLINE hkcdStaticMeshTreeBase::Primitive::Type   hkcdStaticMeshTreeBase::Primitive::getType(int a, int b, int c, int d)
{
    if ( b != d )
    {
        if(c == d)
            return TRIANGLE;
        else
            return QUAD;
    }
    else
    {
        if( c == EXTERNAL )
        {
            return EXTERNAL;
        }
        else if( c == CUSTOM )
        {
            return CUSTOM;
        }
        else
        {
            HK_ASSERT(0x3017EF70, a == 0xde && b == 0xad && c == 0xde && d == 0xad, "Unknown primitive type identifier");
            return INVALID;
        }
    }
}

//
// Section decoder.
//

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE void  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::initialize(const hkcdStaticMeshTree* mesh, hkBool32 forceSingleTriangles)
{
    m_mesh                  =   mesh;
    m_primitiveStoresIsFlatConvex = forceSingleTriangles ? 0 : mesh->m_primitiveStoresIsFlatConvex;
    m_section               =   HK_NULL;
    m_primitives            =   HK_NULL;
    m_packedVertices        =   HK_NULL;
    m_sharedVertices        =   HK_NULL;
    m_sharedVerticesIndex   =   HK_NULL;
    m_primitiveDataRuns     =   HK_NULL;
    m_firstSharedIndex      =   0;
    m_sectionIndex          =   -1;
    m_nodeSectionIndex      =   -1;
    SharedCodec::setupParameters(m_mesh->m_domain, m_sharedParms);
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
void    hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::setSection(int section, bool requireSectionTree)
{
    HK_ASSERT(0x27D161E5, section >= 0 && section < m_mesh->m_sections.getSize(), "Section index out-of-range");
    if(section != m_sectionIndex || (requireSectionTree && (m_nodeSectionIndex != section)))
    {
        m_section               =   &m_mesh->m_sections[section];
        m_nodeSectionIndex      =   section;

        m_sectionIndex          =   section;
        m_packedVertices        =   m_mesh->m_packedVertices.begin() + m_section->m_firstPackedVertex;
        m_sharedVertices        =   m_mesh->m_sharedVertices.begin() + (int)m_section->m_page * SHARED_VERTICES_PAGE_SIZE;
        m_sharedVerticesIndex   =   m_mesh->m_sharedVerticesIndex.begin() + m_section->m_sharedVertices.getFirstShared();
        m_primitiveDataRuns     =   m_mesh->m_primitiveDataRuns.begin() + m_section->m_dataRuns.getFirst();
        m_firstSharedIndex      =   m_section->m_sharedVertices.getFirstLocal();
        m_primitives            =   m_mesh->m_primitives.begin() + m_section->m_primitives.getFirst();
        m_packedParms.load(m_section->m_codecParms);

        m_sharedVerticesIndex   =   (const hkUint16*)m_sharedVerticesIndex - (int) m_section->m_sharedVertices.getFirstLocal();
    }
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE void  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::setSection(const Section*& section)
{
    setSection((int) (section - m_mesh->m_sections.begin()));
}


//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE const hkcdStaticMeshTreeBase::Primitive*  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getPrimitive(int localIndex) const
{
    return m_primitives + localIndex;
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE hkcdStaticMeshTreeBase::Primitive::Type       hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getPrimitiveType(int localIndex) const
{
    return getPrimitive(localIndex)->getType();
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE hkUint32  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getPrimitiveKey(int localIndex, int triangle) const
{
    const hkUint32  sKey = (hkUint32) m_sectionIndex;
    const hkUint32  pKey = (hkUint32) ((localIndex<<1) | triangle);
    return (sKey << 8) | pKey;
}



//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE int           hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getCustomPrimitiveType(int localIndex) const
{
    HK_ASSERT(0xEB8E813F, getPrimitiveType(localIndex) == Primitive::CUSTOM, "The primitive must be custom");
    return (int) (m_sharedVerticesIndex[m_primitives[localIndex].m_indices[0]] & 0xf);
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE int           hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getCustomPrimitiveNumTags(int localIndex) const
{
    HK_ASSERT(0xEB8E813F, getPrimitiveType(localIndex) == Primitive::CUSTOM || getPrimitiveType(localIndex) == Primitive::EXTERNAL, "The primitive must be custom");
    return (int) (m_sharedVerticesIndex[m_primitives[localIndex].m_indices[0]] >> 6) & 0x3;
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
template <typename T>
HK_INLINE const T&  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getCustomPrimitiveTag(int localIndex, int tagIndex) const
{
    HK_COMPILE_TIME_ASSERT(sizeof(T) == sizeof(hkUint16));
    HK_ASSERT(0xEB8E813F, getPrimitiveType(localIndex) == Primitive::CUSTOM || getPrimitiveType(localIndex) == Primitive::EXTERNAL, "The primitive must be custom");
    HK_ASSERT(0x48F9BB47, tagIndex >= 0 && tagIndex < getCustomPrimitiveNumTags(localIndex), "Invalid tag index");
    return * (const T*) (&m_sharedVerticesIndex[m_primitives[localIndex].m_indices[0] + 2 + tagIndex]);
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE hkcdStaticMeshTreeBase::CompressionMode   hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getCustomPrimitiveCompressionMode(int localIndex) const
{
    HK_ASSERT(0xEB8E813F, getPrimitiveType(localIndex) == Primitive::CUSTOM, "The primitive must be custom");
    return (CompressionMode) ((m_sharedVerticesIndex[m_primitives[localIndex].m_indices[0]] >> 4) & 0x3);
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE int           hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getCustomPrimitiveNumVertices(int localIndex) const
{
    HK_ASSERT(0xEB8E813F, getPrimitiveType(localIndex) == Primitive::CUSTOM, "The primitive must be custom");
    return (int) (m_sharedVerticesIndex[m_primitives[localIndex].m_indices[0]] >> 8);
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE int           hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getCustomPrimitiveVertices(int localIndex, const hkAabb& aabb, hkVector4* HK_RESTRICT verticesOut, int maxVertices) const
{
    HK_ASSERT(0xEB8E813F, getPrimitiveType(localIndex) == Primitive::CUSTOM, "The primitive must be custom");
    const int           numVertices = hkMath::min2(getCustomPrimitiveNumVertices(localIndex),maxVertices);
    const Primitive&    primitive = m_primitives[localIndex];
    const hkUint16      firstShared = m_sharedVerticesIndex[1+(int)primitive.m_indices[0]];
    switch(getCustomPrimitiveCompressionMode(localIndex))
    {
    case CM_GLOBAL:
        {
            decompressCustomPrimitiveVertices<SharedCodec,SharedType>(m_sharedParms, numVertices, &m_sharedVertices[firstShared], verticesOut);
        }
        break;
    case CM_LOCAL_4:
        {
            CodecParameters codecParameters; Local4Codec::setupParameters(aabb, codecParameters);
            decompressCustomPrimitiveVertices<Local4Codec,hkUint32>(codecParameters, numVertices, (const hkUint32*) &m_sharedVertices[firstShared], verticesOut);
        }
        break;
    case CM_LOCAL_2:
        {
            CodecParameters codecParameters; Local2Codec::setupParameters(aabb, codecParameters);
            decompressCustomPrimitiveVertices<Local2Codec,hkUint16>(codecParameters, numVertices, (const hkUint16*) &m_sharedVertices[firstShared], verticesOut);
        }
        break;
    default: HK_ERROR(0x902F09ED, "Compression method #"<<getCustomPrimitiveCompressionMode(localIndex)<<" not implemented"); break;
    }
    return numVertices;
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
template <typename CODEC, typename CPV>
HK_INLINE void  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::decompressCustomPrimitiveVertices(const CodecParameters& parms, int numVertices, const CPV* inputs, hkVector4* HK_RESTRICT verticesOut) const
{
    int i = 0;
    for(; i<(numVertices-1); i+=2)
    {
        CODEC::decode(parms, inputs[hkcdStaticMeshTreeBase::fetchIndex<CPV,SharedType>(i)],   verticesOut[i]);
        CODEC::decode(parms, inputs[hkcdStaticMeshTreeBase::fetchIndex<CPV,SharedType>(i+1)], verticesOut[i+1]);
    }
    if( i<numVertices )
    {
        CODEC::decode(parms, inputs[hkcdStaticMeshTreeBase::fetchIndex<CPV,SharedType>(i)], verticesOut[i]);
    }
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
typename hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::TriangleDataType hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getPrimitiveData(int localIndex) const
{
    const TriangleDataType*     data = HK_NULL;
    const PrimitiveDataRun*     runs = m_primitiveDataRuns;
    int                         searchBounds[] = { 0, int(m_section->m_dataRuns.getCount() - 1) };
    for(;;)
    {
        const int   count = 1 + (searchBounds[1] - searchBounds[0]);
        if(count > 4)
        {   // Binary search.
            const int   midPoint = (searchBounds[1] + searchBounds[0]) >> 1;
            const int   delta = localIndex - runs[midPoint].getIndex();
            if(delta >= 0)
            {
                if(delta < runs[midPoint].getCount())
                {
                    data = &runs[midPoint].getValue();
                    break;
                } else searchBounds[0] = midPoint + 1;
            } else searchBounds[1] = midPoint;
        }
        else
        {   // Linear search.
            runs    +=  searchBounds[0];
            for(int i=0; i<count; ++i,++runs)
            {
                const int   delta = localIndex - runs->getIndex();
                if(delta >= 0 && delta < runs->getCount())
                {
                    data = &runs->getValue();
                    break;
                }
            }
            break;
        }
    }
    HK_ASSERT_NO_MSG( 0xB4544B72, data );   //"Cannot find primitive data"
    return *data;
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE void  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::getPrimitiveAabb(int localIndex, hkAabb& aabbOut) const
{
    if(getPrimitiveType(localIndex) == Primitive::CUSTOM)
        m_section->getNodeAabb(getPrimitive(localIndex)->m_indices[1], aabbOut);
    else
        m_section->getNodeAabb(m_section->findLeafByValue(localIndex), aabbOut);
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN> 
HK_INLINE void  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::decodeVertex(int localIndex, hkVector4& vertexOut) const
{
    if(localIndex >= m_firstSharedIndex)
    {
        SharedCodec::decode(m_sharedParms, m_sharedVertices[m_sharedVerticesIndex[localIndex]], vertexOut);
    }
    else
    {
        PackedCodec::decode(m_packedParms, m_packedVertices[localIndex], vertexOut);
    }
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE void  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::decodeVertex(hkUint32 primitiveKey, int index, hkVector4& vertexOut) const
{
    HK_ASSERT(0xF4648DF4, m_sectionIndex == (int)(primitiveKey>>8), "Current decoder section do not match primitive key");
    const ExpandedPrimitiveKey  expKey(primitiveKey);
    HK_ASSERT(0xEB8E802F, isPrimitiveTriangleOrQuad(expKey.m_primitive), "The primitive must be a triangle or a quad");
    const Primitive&            primitive = m_primitives[expKey.m_primitive];
    const int                   vMap[2][3] = {{0,1,2},{0,2,3}};
    decodeVertex(primitive.m_indices[vMap[expKey.m_triangle][index]], vertexOut);
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE int                   hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::decodePrimitiveFromKey(hkUint32 key, hkVector4* verticesOut)
{
    setSection((int)key>>8);
    waitForCompletion();
    return decodePrimitive((int)((key>>1)&127), verticesOut);
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE void  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::decodeVertex(int localIndex, PackedType& indexOut) const
{
    HK_ASSERT(0x7D0210C4, localIndex < m_firstSharedIndex, "Inconsistent index");
    indexOut = m_packedVertices[localIndex];
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE void  hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::decodeVertex(hkUint32 primitiveKey, int index, PackedType& indexOut) const
{
    HK_ASSERT(0xF4648DF4, m_sectionIndex == (int)(primitiveKey>>8), "Current decoder section do not match primitive key");
    const ExpandedPrimitiveKey  expKey(primitiveKey);
    HK_ASSERT(0xEB8E802F, isPrimitiveTriangleOrQuad(expKey.m_primitive), "The primitive must be a triangle or a quad");
    const Primitive&            primitive = m_primitives[expKey.m_primitive];
    const int                   vMap[2][3] = {{0,1,2},{0,2,3}};
    decodeVertex(primitive.m_indices[vMap[expKey.m_triangle][index]], indexOut);
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE int       hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::decodePrimitive(int localIndex, hkVector4* HK_RESTRICT verticesOut) const
{
    HK_ASSERT(0xEB8E802F, isPrimitiveTriangleOrQuad(localIndex), "The primitive must be a triangle or a quad");
    const Primitive&    primitive = m_primitives[localIndex];
    #if 0
    hkIntVector         sharedOffset; sharedOffset.setAll(m_firstSharedIndex);
    hkIntVector         indices; indices.set(primitive.m_indices[0], primitive.m_indices[1], primitive.m_indices[2], primitive.m_indices[3]);
    hkVector4Comparison comp; comp.setNot(indices.compareLessThanS32(sharedOffset));
    #define DECODE_AS_SHARED(_i_) SharedCodec::decode(m_sharedParms, m_sharedVertices[m_sharedVerticesIndex[primitive.m_indices[_i_]]], verticesOut[_i_])
    #define DECODE_AS_PACKED(_i_) PackedCodec::decode(m_packedParms, m_packedVertices[primitive.m_indices[_i_]], verticesOut[_i_])
    switch(comp.getMask() & 15)
    {
        case    0:  DECODE_AS_PACKED(0); DECODE_AS_PACKED(1); DECODE_AS_PACKED(2); DECODE_AS_PACKED(3); break;
        case    1:  DECODE_AS_SHARED(0); DECODE_AS_PACKED(1); DECODE_AS_PACKED(2); DECODE_AS_PACKED(3); break;
        case    2:  DECODE_AS_PACKED(0); DECODE_AS_SHARED(1); DECODE_AS_PACKED(2); DECODE_AS_PACKED(3); break;
        case    3:  DECODE_AS_SHARED(0); DECODE_AS_SHARED(1); DECODE_AS_PACKED(2); DECODE_AS_PACKED(3); break;
        case    4:  DECODE_AS_PACKED(0); DECODE_AS_PACKED(1); DECODE_AS_SHARED(2); DECODE_AS_PACKED(3); break;
        case    5:  DECODE_AS_SHARED(0); DECODE_AS_PACKED(1); DECODE_AS_SHARED(2); DECODE_AS_PACKED(3); break;
        case    6:  DECODE_AS_PACKED(0); DECODE_AS_SHARED(1); DECODE_AS_SHARED(2); DECODE_AS_PACKED(3); break;
        case    7:  DECODE_AS_SHARED(0); DECODE_AS_SHARED(1); DECODE_AS_SHARED(2); DECODE_AS_PACKED(3); break;
        case    8:  DECODE_AS_PACKED(0); DECODE_AS_PACKED(1); DECODE_AS_PACKED(2); DECODE_AS_SHARED(3); break;
        case    9:  DECODE_AS_SHARED(0); DECODE_AS_PACKED(1); DECODE_AS_PACKED(2); DECODE_AS_SHARED(3); break;
        case    10: DECODE_AS_PACKED(0); DECODE_AS_SHARED(1); DECODE_AS_PACKED(2); DECODE_AS_SHARED(3); break;
        case    11: DECODE_AS_SHARED(0); DECODE_AS_SHARED(1); DECODE_AS_PACKED(2); DECODE_AS_SHARED(3); break;
        case    12: DECODE_AS_PACKED(0); DECODE_AS_PACKED(1); DECODE_AS_SHARED(2); DECODE_AS_SHARED(3); break;
        case    13: DECODE_AS_SHARED(0); DECODE_AS_PACKED(1); DECODE_AS_SHARED(2); DECODE_AS_SHARED(3); break;
        case    14: DECODE_AS_PACKED(0); DECODE_AS_SHARED(1); DECODE_AS_SHARED(2); DECODE_AS_SHARED(3); break;
        case    15: DECODE_AS_SHARED(0); DECODE_AS_SHARED(1); DECODE_AS_SHARED(2); DECODE_AS_SHARED(3); break;
    }
    #undef DECODE_AS_SHARED
    #undef DECODE_AS_PACKED
    #else
        decodeVertex(primitive.m_indices[0], verticesOut[0]);
        decodeVertex(primitive.m_indices[1], verticesOut[1]);
        decodeVertex(primitive.m_indices[2], verticesOut[2]);
        decodeVertex(primitive.m_indices[3], verticesOut[3]);
    #endif

    return primitive.m_indices[2] == primitive.m_indices[3] ? 1 : 2;
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE int       hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::decodePrimitive(int localIndex, PackedType* indicesOut) const
{
    HK_ASSERT(0xEB8E802F, isPrimitiveTriangleOrQuad(localIndex), "The primitive must be a triangle or a quad");
    const Primitive&    primitive = m_primitives[localIndex];
    decodeVertex(primitive.m_indices[0], indicesOut[0]);
    decodeVertex(primitive.m_indices[1], indicesOut[1]);
    decodeVertex(primitive.m_indices[2], indicesOut[2]);
    decodeVertex(primitive.m_indices[3], indicesOut[3]);
    return primitive.m_indices[2] == primitive.m_indices[3] ? 1 : 2;
}


template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN>
HK_INLINE hkBool32              hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::isPrimitiveFlatConvex(int localIndex) const
{
    const Primitive& p = m_primitives[localIndex];
    HK_ASSERT_NO_MSG( 0xf045456, p.getType() == Primitive::QUAD );
    return p.isFlatConvexQuad(m_primitiveStoresIsFlatConvex);
}

//
template <typename CT_CONFIG, typename PRIMITIVE_DATA_RUN> 
HK_INLINE hkBool32              hkcdStaticMeshTree<CT_CONFIG,PRIMITIVE_DATA_RUN>::Decoder::isPrimitiveTriangleOrQuad(int localIndex) const
{
    return m_primitives[localIndex].isTriangleOrQuad();
}

//
// Expanded primitive key.
//

//
HK_INLINE void      hkcdStaticMeshTreeBase::ExpandedPrimitiveKey::setPrimitiveKey(hkUint32 primitiveKey)
{
    m_section   =   (int) (primitiveKey >> 8);
    m_primitive =   (int) ((primitiveKey >> 1) & 127);
    m_triangle  =   (int) (primitiveKey & 1);
}

//
// Filter.
//

//
HK_INLINE hkBool32  hkcdStaticMeshTreeBase::getNodeFilter(const Filter& filter, const NodeContext& node) const
{
    const hkUint32* data = filter.begin() + (m_sections.getSize() << 3);
    return (hkBool32) hkcdStaticTree::Filtering<1>::get(data,node.m_index);
}

//
HK_INLINE hkUint32  hkcdStaticMeshTreeBase::getPrimitiveFilter(const Filter& filter, int section, int primitive) const
{
    const hkUint32* data = filter.begin() + (section << 3);
    return hkcdStaticTree::Filtering<2>::get(data, primitive);
}


/// Vertex CODEC.
template <typename T, int BITS_X, int BITS_Y>
HK_INLINE void  hkcdStaticMeshTreeBase::VertexCODEC<T,BITS_X,BITS_Y>::setupParameters(const hkAabb& aabb, CodecParameters& config)
{
    static hkQuadReal invBitScales = HK_QUADREAL_CONSTANT( 1.0f/MASK_X, 1.0f/MASK_Y, 1.0f/MASK_Z, 1.0f );   
    config.m_scale.setSub(aabb.m_max, aabb.m_min);
    config.m_origin = aabb.m_min;
    config.m_scale.mul( (const hkVector4&)invBitScales);
}

template <typename T, int BITS_X, int BITS_Y>
HK_INLINE void  hkcdStaticMeshTreeBase::VertexCODEC<T,BITS_X,BITS_Y>::encode(const hkAabb& aabb, const hkVector4& vertex, T& output)
{
    HK_ASSERT(0x0DB8EF07, aabb.containsPoint(vertex), "Vertex outside the quantization domain");
    hkVector4   delta; delta.setSub(aabb.m_max, aabb.m_min); delta.setMax(delta, hkVector4::getConstant<HK_QUADREAL_0>());
    hkVector4   invDelta; invDelta.setReciprocal<HK_ACC_23_BIT,HK_DIV_SET_ZERO>(delta);
    hkVector4   offset; offset.setSub(vertex, aabb.m_min);
    hkVector4   fractions; fractions.setMul(offset, invDelta); fractions.setClamped(fractions, hkVector4::getConstant<HK_QUADREAL_0>(), hkVector4::getConstant<HK_QUADREAL_1>());
    const T     x = (T) (fractions(0) * MASK_X + 0.5f);
    const T     y = (T) (fractions(1) * MASK_Y + 0.5f);
    const T     z = (T) (fractions(2) * MASK_Z + 0.5f);
    const T     p = (z << (BITS_PER_X + BITS_PER_Y)) | (y << BITS_PER_Y) | x;
    output = p;
}

template <typename T, int BITS_X, int BITS_Y>
HK_INLINE void hkcdStaticMeshTreeBase::VertexCODEC<T,BITS_X,BITS_Y>::decode(const hkAabb& aabb, const T& vertex, hkVector4& output)
{
    CodecParameters config; setupParameters(aabb, config);

    hkVector4   delta; delta.setSub(aabb.m_max, aabb.m_min);
    const int   x = (int) (vertex & MASK_X);
    const int   y = (int) ((vertex >> BITS_PER_X) & MASK_Y);
    const int   z = (int) ((vertex >> (BITS_PER_X + BITS_PER_Y) ) & MASK_Z);

    hkVector4   fractions;
    fractions.set(x / hkReal(MASK_X), y / hkReal(MASK_Y), z / hkReal(MASK_Z), 0.0f);

    output.setAddMul(aabb.m_min, fractions, delta);
}

template <typename T, int BITS_X, int BITS_Y>
HK_INLINE void hkcdStaticMeshTreeBase::VertexCODEC<T,BITS_X,BITS_Y>::decode(const CodecParameters& config, const T& vertex, hkVector4& output)
{
    hkIntVector iv; iv.set( (int)(vertex & MASK_X), (int)((vertex >> BITS_PER_X) & MASK_Y), (int)((vertex >> (BITS_PER_X + BITS_PER_Y)) & MASK_Z), 0 );
    hkVector4   rv; iv.convertS32ToF32( rv );
    output.setAddMul( config.m_origin, rv, config.m_scale );
}

template <typename T, int BITS_X, int BITS_Y>
HK_INLINE void hkcdStaticMeshTreeBase::VertexCODEC<T,BITS_X,BITS_Y>::roundTrip(const hkAabb& aabb, const hkVector4& vertexIn, hkVector4& vertexOut)
{
    T packed;
    encode(aabb, vertexIn, packed);
    decode(aabb, packed, vertexOut);
}

/*
 * Havok SDK - Product file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
