// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Common/Base/Math/Vector/hkIntVector.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>
#include <Common/Base/Thread/TaskQueue/hkTask.h>

#include <Geometry/Collide/DataStructures/Planar/Primitives/hkcdPlanarGeometryPrimitives.h>
#include <Geometry/Collide/DataStructures/Planar/Memory/hkcdPlanarGeometryPolygonCollection.h>
#include <Geometry/Collide/DataStructures/Planar/Memory/hkcdPlanarGeometryPlanesCollection.h>
#include <Geometry/Collide/DataStructures/Planar/Predicates/hkcdPlanarGeometryPredicates.h>

/// Base class for a planar geometry debugger
class HK_EXPORT_COMMON hkcdPlanarEntityDebugger : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY);

    public:

        /// Constructor
        hkcdPlanarEntityDebugger()
        :   hkReferencedObject()
        {}

    public:

        /// Called by the geometric entities during processing. Can be used to capture snapshots of the geometries during execution.
        virtual void addTrace(_In_z_ const char* debugTraceString, _In_opt_ const class hkcdPlanarEntity* callerEntity) {}

        /// Called by the geometric entities during processing.
        virtual int addGeometry(_In_z_ const char* geometryName, _In_opt_ const hkGeometry* tempGeometry) { return -1; }
};

/// Base class for all plane-based geometric objects
class HK_EXPORT_COMMON hkcdPlanarEntity : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY);
        HK_DECLARE_REFLECTION();

    public:

        // Types
        typedef hkcdPlanarGeometryPrimitives::Plane                     Plane;
        typedef hkcdPlanarGeometryPrimitives::PlaneId                   PlaneId;
        typedef hkcdPlanarGeometryPolygonCollection::Polygon            Polygon;
        typedef hkcdPlanarGeometryPolygonCollection::PolygonId          PolygonId;
        typedef hkcdPlanarGeometryPolygonCollection::Material           Material;
        typedef hkcdPlanarGeometryPolygonCollection::TriangleProviderId TriangleProviderId;
        typedef hkcdPlanarGeometryPredicates::Orientation               Orientation;
        typedef hkcdPlanarGeometryPlanesCollection::OrientationCache    OrientationCache;
        typedef hkcdPlanarGeometryPlanesCollection                      PlanesCollection;
        typedef hkTask::ExecutionContext                                ExecutionContext;

    public:

        /// Constructor
        hkcdPlanarEntity(_In_opt_ hkcdPlanarEntityDebugger* debugger = HK_NULL)
        :   hkReferencedObject()
        ,   m_debugger(debugger)
        {}

        /// Copy constructor
        hkcdPlanarEntity(const hkcdPlanarEntity& other)
        :   hkReferencedObject()
        ,   m_debugger(other.m_debugger)
        {}

        /// Builds a vertex-based geometry representation from this entity. Default implementation does nothing.
        virtual void extractGeometry(hkGeometry& geomOut) const {}

    public:

        /// Returns the debugger
        HK_INLINE _Ret_maybenull_ const hkcdPlanarEntityDebugger* getDebugger() const   {   return m_debugger;  }
        HK_INLINE _Ret_maybenull_ hkcdPlanarEntityDebugger* accessDebugger()            {   return m_debugger;  }

    protected:

        /// Adds a debug trace
        HK_INLINE void addTrace(_In_z_ const char* debugString) const
        {
            if ( m_debugger )
            {
                m_debugger->addTrace(debugString, this);
            }
        }

    protected:

        /// The debugger, can be null
        hkRefPtr<hkcdPlanarEntityDebugger> m_debugger;      //+nosave
};

HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkcdPlanarEntity::PlanesCollection, hkcdPlanarEntity_PlanesCollection_Tag);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
