// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Geometry/Collide/DataStructures/Planar/Primitives/hkcdPlanarGeometryPrimitives.h>
#include <Common/Base/Algorithm/Collide/1AxisSweep/hk1AxisSweep.h>

/// Utility that welds together an array of planes
class HK_EXPORT_COMMON hkcdPlanarGeometryWeldUtil
{
    public:

        HK_DECLARE_CLASS(hkcdPlanarGeometryWeldUtil, New);
        typedef hkcdPlanarGeometryPrimitives::Plane             Plane;

    public:

        /// Welds the given set of planes. Assumes the boundary planes are present only once among the planes to be welded, in the first 6 slots!
        static void HK_CALL weldPlanes(const hkArray<Plane>& planesIn, hkArray<Plane>& weldedPlanesOut, hkArray<int>& remapTableOut);

        /// Computes a mapping between two plane sets. The first plane set provided is assumed to be included in the second plane set
        static void HK_CALL computeMappingBetweenPlaneSets(const hkArray<Plane>& planesIncluded, const hkArray<Plane>& allPlanes, hkArray<int>& remapTableOut, int invalidPlaneValue);

        /// Returns a list of pairs of input points clolsest than the specified tolerance
        static void getPotentiallyCollidingPoints(hkArray<hkIntVector>& m_points, hkUint32 tolerance, hkArray<hkKeyPair>& pairs);

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
